

#include "open_files.h"
#include "options.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qstringlist.h>

#include <klocale.h>


OpenFiles::OpenFiles( QStringList list, QWidget *parent, const char *name, bool modal, WFlags f )
    : QDialog( parent, name, modal, f )
{
    setCaption( QString(i18n("Open files")).append(" - soundKonverter") );

    files=list;
    int row=1;

    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    options = new Options( this, "options", 1 );
    grid->addWidget( options, 0, 0 );

    QStringList::Iterator it = files.begin();
    while( it != files.end() )
    {
        QString sFormat=*it;
        int i=sFormat.findRev('.');
        sFormat.remove(0,i+1);
        sFormat.lower();

        if( sFormat == "wav" )
        {
            QHBoxLayout *warningBox = new QHBoxLayout();
            grid->addLayout( warningBox, 1, 0 );
            QLabel *lWarning = new QLabel( i18n("Warning: If you select \"wav\" as output format, your wav files will not be added to the list."), this, "lWarning" );
            warningBox->addWidget(lWarning);
            row++;
            break;
        }
        it++;
    }

    QHBoxLayout *buttonBox = new QHBoxLayout( );
    grid->addLayout( buttonBox, row, 0 );

    buttonBox->addStretch();

    pCancel = new QPushButton( i18n("Cancel"), this, "pCancel" );
    buttonBox->addWidget( pCancel );

    pOk = new QPushButton( i18n("Ok"), this, "pOk" );
    buttonBox->addWidget( pOk );

    connect( pCancel, SIGNAL(clicked()),
             this, SLOT(reject()) );
    connect( options, SIGNAL(allFilesAdded()),
             this, SLOT(accept()) );
    connect( pOk, SIGNAL(clicked()),
             this, SLOT(okClicked()) );

    connect( this, SIGNAL(addFiles(QStringList)),
             options, SLOT(addFiles(QStringList)) );
    connect( options, SIGNAL(addFile(QStringList)),
             this, SLOT(fileAdded(QStringList)) );
    connect( options, SIGNAL(timeAdded(float)),
             this, SLOT(addTime(float)) );
}

OpenFiles::~OpenFiles()
{
}

void OpenFiles::okClicked()
{
    emit addFiles(files);
}

void OpenFiles::fileAdded(QStringList list)
{
    emit addFile(list);
}

void OpenFiles::addTime(float time)
{
    emit timeAdded(time);
}


