

#include "debug_tab.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qfont.h>
#include <qtimer.h>

#include <klocale.h>
#include <kapplication.h>

DebugTab::DebugTab( QWidget *parent, const char *name, int text )
    : QWidget( parent, name )
{
    QGridLayout *grid = new QGridLayout( this, 2, 1, 10, 5 );

    QHBoxLayout *topBox = new QHBoxLayout( );
    grid->addLayout( topBox, 0, 0 );

    lProcessedTime = new QLabel( "0", this, "lProcessedTime" );
    lProcessedTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lProcessedTime, 0, Qt::AlignVCenter );

    QLabel *lSlash1 = new QLabel( "/", this, "lSlash1" );
    topBox->addWidget( lSlash1, 0, Qt::AlignVCenter );

    lTotalTime = new QLabel( "0", this, "lTotalTime" );
    lTotalTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lTotalTime, 0, Qt::AlignVCenter );

    QLabel *lClip1 = new QLabel( "[", this, "lClip1" );
    topBox->addWidget( lClip1, 0, Qt::AlignVCenter );

    lActFileEncTime = new QLabel( "0", this, "lActFileEncTime" );
    lActFileEncTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lActFileEncTime, 0, Qt::AlignVCenter );

    QLabel *lPlus1 = new QLabel( "+", this, "lPlus1" );
    topBox->addWidget( lPlus1, 0, Qt::AlignVCenter );

    lActFileDecTime = new QLabel( "0", this, "lActFileDecTime" );
    lActFileDecTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lActFileDecTime, 0, Qt::AlignVCenter );

    QLabel *lPlus2 = new QLabel( "+", this, "lPlus2" );
    topBox->addWidget( lPlus2, 0, Qt::AlignVCenter );

    lActFileRepTime = new QLabel( "0", this, "lActFileRepTime" );
    lActFileRepTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lActFileRepTime, 0, Qt::AlignVCenter );

    QLabel *lEqual1 = new QLabel( "=", this, "lEqual1" );
    topBox->addWidget( lEqual1, 0, Qt::AlignVCenter );

    lActFileTime = new QLabel( "0", this, "lActFileTime" );
    lActFileTime->setFont( QFont( "Courier" ) );
    topBox->addWidget( lActFileTime, 0, Qt::AlignVCenter );

    QLabel *lClip2 = new QLabel( "]", this, "lClip2" );
    topBox->addWidget( lClip2, 0, Qt::AlignVCenter );

    topBox->addStretch();

    QTimer *timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), this, SLOT(recalc()) );
    timer->start( 100, true );

    totalTime=0;
}

DebugTab::~DebugTab()
{
}

void DebugTab::recalc()
{
    char str[128];

    sprintf(str,"%.2f",totalTime);
    lTotalTime->setText(str);
}

