

#ifndef _CUE_EDITOR_H_
#define _CUE_EDITOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>


class QTextEdit;
class KPushButton;

/**
 * @short CueEditor
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class CueEditor : public QDialog
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    CueEditor( QWidget *parent=0, const char *name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~CueEditor();

private slots:
    void help();
    void convert();
    void generate();
    void shift();

private:
    QTextEdit *tTextEdit;
    KPushButton *pHelp;
    KPushButton *pGenerate;
    KPushButton *pConvert;
    KPushButton *pShift;
    KPushButton *pOk;

};

#endif // _CUE_EDITOR_H_
