

#include "convert.h"
#include "config.h"
#include "processoptions.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <qfile.h>
#include <qfileinfo.h>
#include <qregexp.h>

#include <klocale.h>
#include <kuser.h>

#include <sys/types.h>
#include <unistd.h>

Convert::Convert()
{
    priority=0;

    connect(&pDecode,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(decodeOutput(KProcess*,char*,int)));
    connect(&pDecode,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(decodeOutput(KProcess*,char*,int)));
    connect(&pDecode,SIGNAL(processExited(KProcess*)),this,SLOT(decodeExit(KProcess*)));

    connect(&pEncode,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(encodeOutput(KProcess*,char*,int)));
    connect(&pEncode,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(encodeOutput(KProcess*,char*,int)));
    connect(&pEncode,SIGNAL(processExited(KProcess*)),this,SLOT(encodeExit(KProcess*)));

    connect(&pReplayGain,SIGNAL(receivedStdout(KProcess*,char*,int)),this,SLOT(replayGainOutput(KProcess*,char*,int)));
    connect(&pReplayGain,SIGNAL(receivedStderr(KProcess*,char*,int)),this,SLOT(replayGainOutput(KProcess*,char*,int)));
    connect(&pReplayGain,SIGNAL(processExited(KProcess*)),this,SLOT(replayGainExit(KProcess*)));
}

Convert::~Convert()
{
}

void Convert::encode()
{
    QStringList params;
    QString param, paramSplinter;
    char cs[32];
    int is;
    float fs;
    QString sQuality;
    QString sBitrate;
    QString sMinBitrate;
    QString sMaxBitrate;
    QString sStrength;
    QString sSampleRate;

    QString sCmd;
    QString sV, sLevel;

    pEncode.clearArguments();

    BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).encoder);

    param=QString::null;
    if( plugin.enc.param != QString::null ) param.append(" "+plugin.enc.param);

    if( plugin.enc.strength.enabled ) {
        param.append(" "+plugin.enc.strength.param);
        if( plugin.enc.strength.profiles.empty() ) {
            if( plugin.enc.strength.step < 1 ) {
                if( plugin.enc.strength.range_max >= plugin.enc.strength.range_min )
                    fs = prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel * plugin.enc.strength.step;
                else
                    fs = plugin.enc.strength.range_min - prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel * plugin.enc.strength.step;
                //fs -= fs%plugin.enc.strength.step;
                sprintf( cs, "%.2f", fs );
            }
            else {
                if( plugin.enc.strength.range_max >= plugin.enc.strength.range_min )
                    is = (int)(prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel * plugin.enc.strength.step);
                else
                    is = (int)(plugin.enc.strength.range_min - prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel * plugin.enc.strength.step);
                //is -= is%plugin.enc.strength.step;
                sprintf( cs, "%i", is );
            }
            sStrength=QString(cs);
            if( plugin.enc.strength.seperator != '.' ) sStrength.replace(QChar('.'),plugin.enc.strength.seperator);
        }
        else {
            QStringList::Iterator it=plugin.enc.strength.profiles.at(prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel);
            sStrength=*it;
        }
    }

    if( actFile.Convert.Quality.EMode == EBitrate ) {
        if( actFile.Convert.Quality.sBitrateMode == "cbr" && plugin.enc.bitrate.cbr.enabled ) {
            param.append(" "+plugin.enc.bitrate.cbr.param);
            sprintf( cs, "%i", actFile.Convert.Quality.iOutputBitrate );
            sBitrate=QString(cs);
        }
        else if( actFile.Convert.Quality.sBitrateMode == "abr" && plugin.enc.bitrate.abr.enabled ) {
            param.append(" "+plugin.enc.bitrate.abr.param);
            sprintf( cs, "%i", actFile.Convert.Quality.iOutputBitrate );
            sBitrate=QString(cs);
            if( actFile.Convert.Quality.bRange && plugin.enc.bitrate.abr.bitrate_range.enabled ) {
                param.append(" "+plugin.enc.bitrate.abr.bitrate_range.param_min);
                sprintf( cs, "%i", actFile.Convert.Quality.iMinBitrate );
                sMinBitrate=QString(cs);
                param.append(" "+plugin.enc.bitrate.abr.bitrate_range.param_max);
                sprintf( cs, "%i", actFile.Convert.Quality.iMaxBitrate );
                sMaxBitrate=QString(cs);
            }
        }
    }
    else if( actFile.Convert.Quality.EMode == EQuality && plugin.enc.quality.enabled ) {
        param.append(" "+plugin.enc.quality.param);
        if( plugin.enc.quality.profiles.empty() ) {
            if( plugin.enc.quality.step < 1 ) {
                if( plugin.enc.quality.range_max >= plugin.enc.quality.range_min)
                    fs = ( (float)actFile.Convert.Quality.iLevel * (plugin.enc.quality.range_max-plugin.enc.quality.range_min) / 100 ) + plugin.enc.quality.range_min;
                else
                    fs = ( (100.0f - (float)actFile.Convert.Quality.iLevel) * (plugin.enc.quality.range_min-plugin.enc.quality.range_max) / 100 ) + plugin.enc.quality.range_max;
                //fs -= fs%plugin.enc.quality.step;
                sprintf( cs, "%.2f", fs );
            }
            else {
                if( plugin.enc.quality.range_max >= plugin.enc.quality.range_min)
                    is = ( actFile.Convert.Quality.iLevel * (int)(plugin.enc.quality.range_max-plugin.enc.quality.range_min) / 100) + (int)plugin.enc.quality.range_min;
                else
                    is = ( (100 - actFile.Convert.Quality.iLevel) * (int)(plugin.enc.quality.range_min-plugin.enc.quality.range_max) / 100) + (int)plugin.enc.quality.range_max;
                //is -= is%plugin.enc.quality.step;
                sprintf( cs, "%i", is );
            }
            sQuality=QString(cs);
            if( plugin.enc.quality.seperator != '.' ) sQuality.replace(QChar('.'),plugin.enc.quality.seperator);
        }
        else {
            sQuality=*plugin.enc.quality.profiles.at(prefs.fileFormat(actFile.Convert.sOutputFormat).compressionLevel);
        }
    }
    else if( actFile.Convert.Quality.EMode == ELossless && plugin.enc.lossless.enabled ) {
        param.append(" "+plugin.enc.lossless.param);
    }

    if( actFile.SampleRate.bEnabled && plugin.enc.resample.enabled ) {
        param.append(" "+plugin.enc.resample.param);
        if( plugin.enc.resample.unit == BackendPlugins::Hz ) {
            sprintf( cs, "%i", actFile.SampleRate.iOutputSampleRate );
        }
        else {
            sprintf( cs, "%f", (float)actFile.SampleRate.iOutputSampleRate/1000 );
        }
        sSampleRate=QString(cs);
    }

    if( actFile.Channels.bEnabled ) {
        if( actFile.Channels.iOutputChannels == 1 && plugin.enc.channels.mono_enabled ) {
            param.append(" "+plugin.enc.channels.mono_param);
        }
        else if( actFile.Channels.iOutputChannels == 2 && plugin.enc.channels.stereo_enabled ) {
            param.append(" "+plugin.enc.channels.stereo_param);
        }
    }

    if( actFile.bReplayGain && plugin.enc.replaygain.use && prefs.fileFormat(actFile.Convert.sOutputFormat).replaygain == i18n("built-in") ) {
        param.append(" "+plugin.enc.replaygain.use);
    }
    else if( plugin.enc.replaygain.avoid ) {
        param.append(" "+plugin.enc.replaygain.avoid);
    }

    // TODO write tags - good this way?
    if( actFile.Convert.sOutputFormat != "ogg" &&
        actFile.Convert.sOutputFormat != "flac"&&
        actFile.Convert.sOutputFormat != "mp3" &&
        actFile.Convert.sOutputFormat != "mpc" &&
        plugin.enc.tag.enabled ) {
        param.append(" "+plugin.enc.tag.param);
    }

    if( plugin.enc.inOutFiles.find("%p") != -1 ) {
        QString t_str=plugin.enc.inOutFiles;
        t_str.replace("%p",param);
        param=plugin.enc.bin+" "+t_str;
    }
    else {
        param=plugin.enc.bin+param+" "+plugin.enc.inOutFiles;
    }

    // cosmetic surgery
    while( param.find("  ") != -1 ) param.replace("  "," ");
    while( param.at(param.length()-1) == QChar(' ') ) param.remove(param.length()-1,1);

    params=QStringList::split(' ',param);

    char cTrack[16], cYear[16];
    //QString sDebug;

    for( QStringList::Iterator it=params.begin(); it!=params.end(); ++it )
    {
        // replace spacers for starting backend
        paramSplinter=*it;
        paramSplinter.replace("%i",actFile.Convert.sWaveOutputFilename);
        paramSplinter.replace("%o",actFile.Convert.sOutputFilename);
        paramSplinter.replace("%q",sQuality);
        paramSplinter.replace("%b",sBitrate);
        paramSplinter.replace("%m",sMinBitrate);
        paramSplinter.replace("%M",sMaxBitrate);
        paramSplinter.replace("%c",sStrength);
        paramSplinter.replace("%s",sSampleRate);

        paramSplinter.replace("%ta",actFile.Tag.sArtist);
        paramSplinter.replace("%tb",actFile.Tag.sAlbum);
        paramSplinter.replace("%tc",actFile.Tag.sComment);
        paramSplinter.replace("%tg",actFile.Tag.sGenre);
        sprintf(cTrack,"%i",actFile.Tag.iTrack);
        paramSplinter.replace("%tn",cTrack);
        paramSplinter.replace("%tt",actFile.Tag.sTitle);
        sprintf(cYear,"%i",actFile.Tag.iYear);
        paramSplinter.replace("%ty",cYear);

        if(paramSplinter!=""){
            pEncode << paramSplinter;
            //sDebug+=" "+paramSplinter;
        }
    }

//emit sendOutput(sDebug);

    // replace spacers for output
    param.replace("%i","\""+actFile.Convert.sWaveOutputFilename+"\"");
    param.replace("%o","\""+actFile.Convert.sOutputFilename+"\"");
    //param.replace("%i",actFile.Convert.sWaveOutputFilename);
    //param.replace("%o",actFile.Convert.sOutputFilename);
    param.replace("%q",sQuality);
    param.replace("%b",sBitrate);
    param.replace("%m",sMinBitrate);
    param.replace("%M",sMaxBitrate);
    param.replace("%c",sStrength);
    param.replace("%s",sSampleRate);

    param.replace("%ta","\""+actFile.Tag.sArtist+"\"");
    param.replace("%tb","\""+actFile.Tag.sAlbum+"\"");
    param.replace("%tc","\""+actFile.Tag.sComment+"\"");
    param.replace("%tg","\""+actFile.Tag.sGenre+"\"");
    param.replace("%tn",cTrack);
    param.replace("%tt","\""+actFile.Tag.sTitle+"\"");
    param.replace("%ty",cYear);

    emit sendOutput(param);
    bKilled=false;

    actFile.step=EEncode;

    pEncode.setPriority(priority);

    lastSignal.start();
    pauseTime.start();
    actFile.Time.tTime.start();
    pEncode.start( KProcess::NotifyOnExit, KProcess::AllOutput );
}

void Convert::encodeOutput( KProcess *proc, char *data, int length )
{
    QString sSpeed="";
    int iPercent=0,iTime=0,iPos=0,iNum=0;
    char cSpeed[7], cPercent[7];
    float fSpeed=0.0f, fPercent=0.0f;

    lastOutput=data;

    if( pauseTime.elapsed() < prefs.convert.pauseMS ) {
        return;
    }
    pauseTime.start();

    BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).encoder);

    QString outputPattern="";

    if( actFile.Convert.Quality.EMode == EQuality ) {
        outputPattern = plugin.enc.quality.output;
    }
    else if( actFile.Convert.Quality.EMode == EBitrate &&
            actFile.Convert.Quality.sBitrateMode == "abr" ) {
        outputPattern = plugin.enc.bitrate.abr.output;
    }
    else if( actFile.Convert.Quality.EMode == EBitrate &&
            actFile.Convert.Quality.sBitrateMode == "cbr" ) {
        outputPattern = plugin.enc.bitrate.cbr.output;
    }
    else if( actFile.Convert.Quality.EMode == ELossless ) {
        outputPattern = plugin.enc.lossless.output;
    }
    else {
        outputPattern = plugin.enc.lossless.output;
    }
    outputPattern.replace("%i","%p"); // for compatibility with old plugins

    if( outputPattern.find("%i") != -1 ) {
         sscanf(data,outputPattern,&iPercent);
    }
    else if( outputPattern.find("%t") != -1 ) {
         outputPattern.replace("%t","%i");
         sscanf(data,outputPattern,&iTime);
         if( iTime != 0 && actFile.Time.iRealLength != 0 ) iPercent=iTime*100/actFile.Time.iRealLength;
    }
    else if( outputPattern.find("%0") != -1 && outputPattern.find("%1") != -1 ) {
         if( outputPattern.find("%0") < outputPattern.find("%1") ) {
             outputPattern.replace("%0","%i");
             outputPattern.replace("%1","%i");
             sscanf(data,outputPattern,&iPos,&iNum);
         }
         else {
             outputPattern.replace("%0","%i");
             outputPattern.replace("%1","%i");
             sscanf(data,outputPattern,&iNum,&iPos);
         }
         if( iPos != 0 && iNum != 0 ) iPercent=iPos*100/iNum;
    }

    if( iPercent != 0 )
    {
        actFile.Process.iPercent=iPercent;
        actFile.Process.fPercentTime=iPercent*actFile.Time.fEnc;
        sprintf( cPercent, "%i%%", iPercent );
        actFile.Process.sPercent=cPercent;
        actFile.Process.fSpeed=fSpeed;
        if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
            sprintf( cSpeed, "%.2f", fSpeed );
            sSpeed = QString( cSpeed ).append( "x" );
        }
        else {
            fSpeed=0; sSpeed="";
        }
        actFile.Process.sSpeed=sSpeed;

        lastSignal.start();

        emit updateStatus();
    }
    else
    {
        if( lastSignal.elapsed() > prefs.convert.pauseMS*5 )
        {
            iPercent=(int)((80.0f*actFile.Time.tTime.elapsed())/(actFile.Time.fEnc*1000.0f));
            if( iPercent > 100 ) iPercent=100;
            actFile.Process.iPercent=iPercent;
            actFile.Process.fPercentTime=iPercent*actFile.Time.fEnc;
            sprintf( cPercent, "%i%%", iPercent );
            actFile.Process.sPercent=cPercent;
            fSpeed = (float)(actFile.Time.iRealLength * iPercent * 10) / actFile.Time.tTime.elapsed();
            actFile.Process.fSpeed=fSpeed;
            if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
                sprintf( cSpeed, "%.2f", fSpeed );
                sSpeed = QString( cSpeed ).append( "x" );
            }
            else {
                fSpeed=0; sSpeed="";
            }
            actFile.Process.sSpeed=sSpeed;

            lastSignal.start();

            emit updateStatus();
        }
    }
}

void Convert::encodeExit( KProcess *proc )
{
    cleanUp( );

    if( bKilled ) {
        bKilled = false;
        emit exited(2);
    }
    else {
        if( pEncode.exitStatus() != 0 ) {
            emit sendOutput( i18n("We recived an error! Try to change the program for this file format.") );
            emit sendOutput( i18n("Error:\n")+lastOutput );
            emit exited(1);
            return;
        }
        actFile.Process.iPercent=0;
        actFile.Process.fPercentTime=0;
        emit timeConverted(actFile.Time.fEnc);
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).encoder);
        if( actFile.bReplayGain && prefs.fileFormat(actFile.Convert.sOutputFormat).replaygain != i18n("built-in") ) {
            replayGain();
        }
        else {
            emit timeConverted(actFile.Time.fRep);
            emit exited(0);
        }
    }
}

void Convert::decode()
{
    QStringList params;
    QString param, paramSplinter;

    pDecode.clearArguments();

    BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.sFormat).decoder);

    if( plugin.info.name == i18n("Unnamed") ) {
        for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
        {
            if( (*it).dec.synonymous_formats.findIndex(actFile.sFormat) != -1 ) {
                plugin=*it;
                break;
            }
        }
    }

    param=QString::null;
    if( plugin.dec.param ) param.append(" "+plugin.dec.param);

    if( plugin.dec.inOutFiles.find("%p") != -1 ) {
        QString t_str=plugin.dec.inOutFiles;
        t_str.replace("%p",param);
        param=plugin.dec.bin+" "+t_str;
    }
    else {
        param=plugin.dec.bin+param+" "+plugin.dec.inOutFiles;
    }

    // cosmetic surgery
    while( param.find("  ") != -1 ) param.replace("  "," ");
    while( param.at(param.length()-1) == QChar(' ') ) param.remove(param.length()-1,1);

    params=QStringList::split(' ',param);

    for( QStringList::Iterator it=params.begin(); it!=params.end(); ++it )
    {
        paramSplinter=*it;
        paramSplinter.replace("%i",actFile.sFilename);
        paramSplinter.replace("%o",actFile.Convert.sWaveOutputFilename);
        pDecode << paramSplinter;
    }

    param.replace("%i","\""+actFile.sFilename+"\"");
    param.replace("%o","\""+actFile.Convert.sWaveOutputFilename+"\"");
    //param.replace("%i",actFile.sFilename);
    //param.replace("%o",actFile.Convert.sWaveOutputFilename);
    emit sendOutput(param);
    bKilled=false;

    actFile.step=EDecode;

    pDecode.setPriority(priority);

    lastSignal.start();
    pauseTime.start();
    actFile.Time.tTime.start();
    pDecode.start( KProcess::NotifyOnExit, KProcess::AllOutput );
}

void Convert::decodeOutput( KProcess *proc, char *data, int length )
{
    QString sSpeed="";
    int iPercent=0,iTime=0,iPos=0,iNum=0;
    char cSpeed[7], cPercent[7];
    float fSpeed=0.0f;

    lastOutput=data;

    if( pauseTime.elapsed() < prefs.convert.pauseMS ) {
        return;
    }
    pauseTime.start();

    BackendPlugins::PluginStructure plugin=backendPlugins.plugin(prefs.fileFormat(actFile.sFormat).decoder);

    QString outputPattern="";

    outputPattern = plugin.dec.output;
    outputPattern.replace("%i","%p"); // for compatibility with old plugins

    if( outputPattern.find("%p") != -1 ) {
         outputPattern.replace("%p","%i");
         sscanf(data,outputPattern,&iPercent);
    }
    else if( outputPattern.find("%t") != -1 ) {
         outputPattern.replace("%t","%i");
         sscanf(data,outputPattern,&iTime);
         if( iTime != 0 && actFile.Time.iRealLength != 0 ) iPercent=iTime*100/actFile.Time.iRealLength;
    }
    else if( outputPattern.find("%0") != -1 && outputPattern.find("%1") != -1 ) {
         if( outputPattern.find("%0") < outputPattern.find("%1") ) {
             outputPattern.replace("%0","%i");
             outputPattern.replace("%1","%i");
             sscanf(data,outputPattern,&iPos,&iNum);
         }
         else {
             outputPattern.replace("%0","%i");
             outputPattern.replace("%1","%i");
             sscanf(data,outputPattern,&iNum,&iPos);
         }
         if( iPos != 0 && iNum != 0 ) iPercent=iPos*100/iNum;
    }

    if( iPercent != 0 )
    {
        actFile.Process.iPercent=iPercent;
        actFile.Process.fPercentTime=iPercent*actFile.Time.fDec;
        sprintf( cPercent, "%i%%", iPercent );
        actFile.Process.sPercent=cPercent;
        actFile.Process.fSpeed=fSpeed;
        if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
            sprintf( cSpeed, "%.2f", fSpeed );
            sSpeed = QString( cSpeed ).append( "x" );
        }
        else {
            fSpeed=0; sSpeed="";
        }
        actFile.Process.sSpeed=sSpeed;

        lastSignal.start();

        emit updateStatus();
    }
    else
    {
        if( lastSignal.elapsed() > prefs.convert.pauseMS*5 )
        {
            iPercent=(int)((80.0f*actFile.Time.tTime.elapsed())/(actFile.Time.fDec*1000.0f));
            if( iPercent > 100 ) iPercent=100;
            actFile.Process.iPercent=iPercent;
            actFile.Process.fPercentTime=iPercent*actFile.Time.fDec;
            sprintf( cPercent, "%i%%", iPercent );
            actFile.Process.sPercent=cPercent;
            fSpeed = (float)(actFile.Time.iRealLength * iPercent * 10) / actFile.Time.tTime.elapsed();
            actFile.Process.fSpeed=fSpeed;
            if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
                sprintf( cSpeed, "%.2f", fSpeed );
                sSpeed = QString( cSpeed ).append( "x" );
            }
            else {
                fSpeed=0; sSpeed="";
            }
            actFile.Process.sSpeed=sSpeed;

            lastSignal.start();

            emit updateStatus();
        }
    }
}

void Convert::decodeExit( KProcess *proc )
{
    if( bKilled ) {
        cleanUp();
        bKilled=false;
        emit exited(2);
    }
    else {
        if( pDecode.exitStatus() != 0 ) {
            emit sendOutput( i18n("We recived an error! Try to change the program for this file format.") );
            emit sendOutput( i18n("Error:\n")+lastOutput );
            emit exited(1);
            return;
        }
        actFile.Process.iPercent=0;
        actFile.Process.fPercentTime=0;
        emit timeConverted(actFile.Time.fDec);
        if( actFile.Convert.sOutputFormat != "wav" ) {
            encode();
        }
        else {
            emit exited(0);
        }
    }
}

void Convert::replayGain()
{
    QStringList params;
    QString param, paramSplinter;

    pReplayGain.clearArguments();

    ReplayGainPlugins::PluginStructure plugin=replayGainPlugins.plugin(prefs.fileFormat(actFile.Convert.sOutputFormat).replaygain);

    param=plugin.replaygain.bin;
    if( plugin.replaygain.track ) param.append(" "+plugin.replaygain.track);

    param.append(" "+plugin.inFiles);

    params=QStringList::split(' ',param);

    for( QStringList::Iterator it=params.begin(); it!=params.end(); ++it )
    {
        paramSplinter=*it;
        paramSplinter.replace("%i",actFile.Convert.sOutputFilename);
        pReplayGain << paramSplinter;
    }

    param.replace("%i","\""+actFile.Convert.sOutputFilename+"\"");
    emit sendOutput(param);
    bKilled=false;

    actFile.step=EReplayGain;

    pReplayGain.setPriority(priority);

    lastSignal.start();
    pauseTime.start();
    actFile.Time.tTime.start();
    pReplayGain.start( KProcess::NotifyOnExit, KProcess::AllOutput );
}

void Convert::replayGainOutput( KProcess *proc, char *data, int length )
{
    QString sSpeed="";
    int iPercent=0;
    char cSpeed[7], cPercent[7];
    float fSpeed=0.0f;

    lastOutput=data;

    if( pauseTime.elapsed() < prefs.convert.pauseMS ) {
        return;
    }
    pauseTime.start();

    if( iPercent != 0 )
    {
        actFile.Process.iPercent=iPercent;
        actFile.Process.fPercentTime=iPercent*actFile.Time.fRep;
        sprintf( cPercent, "%i%%", iPercent );
        actFile.Process.sPercent=cPercent;
        actFile.Process.fSpeed=fSpeed;
        if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
            sprintf( cSpeed, "%.2f", fSpeed );
            sSpeed = QString( cSpeed ).append( "x" );
        }
        else {
            fSpeed=0; sSpeed="";
        }
        actFile.Process.sSpeed=sSpeed;

        lastSignal.start();

        emit updateStatus();
    }
    else
    {
        if( lastSignal.elapsed() > prefs.convert.pauseMS*5 )
        {
            iPercent=(int)((80.0f*actFile.Time.tTime.elapsed())/(actFile.Time.fRep*1000.0f));
            if( iPercent > 100 ) iPercent=100;
            actFile.Process.iPercent=iPercent;
            actFile.Process.fPercentTime=iPercent*actFile.Time.fRep;
            sprintf( cPercent, "%i%%", iPercent );
            actFile.Process.sPercent=cPercent;
            fSpeed = (float)(actFile.Time.iRealLength * iPercent * 10) / actFile.Time.tTime.elapsed();
            actFile.Process.fSpeed=fSpeed;
            if( fSpeed < 10000.0f && fSpeed > 0.0f ) {
                sprintf( cSpeed, "%.2f", fSpeed );
                sSpeed = QString( cSpeed ).append( "x" );
            }
            else {
                fSpeed=0; sSpeed="";
            }
            actFile.Process.sSpeed=sSpeed;

            lastSignal.start();

            emit updateStatus();
        }
    }
}

void Convert::replayGainExit( KProcess *proc )
{
    if( bKilled ) {
        bKilled = false;
        emit exited(2);
    }
    else {
        // mp3gain always sends error messages
        if( pReplayGain.exitStatus() != 0 && prefs.fileFormat(actFile.Convert.sOutputFormat).replaygain.find("mp3gain") == -1 ) {
            emit sendOutput( i18n("We recived an error! Try to change the program for this file format.") );
            emit sendOutput( i18n("Error:\n")+lastOutput );
            emit exited(1);
            return;
        }
        actFile.Process.iPercent=0;
        actFile.Process.fPercentTime=0;
        emit timeConverted(actFile.Time.fRep);
        emit exited(0);
    }
}

void Convert::kill()
{ // TODO bStoped=true? Wenn es nicht gelingt zu töten, fertige Datei löschen?
    bKilled=true;

    if( pDecode.isRunning() ) {
        if( pDecode.kill() ) emit sendOutput( i18n("Killed!") );
        else emit sendOutput( i18n("Failed to kill the decoder, trying to stop...") );
    }
    if( pEncode.isRunning() ) {
        if( pEncode.kill() ) emit sendOutput( i18n("Killed!") );
        else emit sendOutput( i18n("Failed to kill the encoder, trying to stop...") );
    }
    if( pReplayGain.isRunning() ) {
        if( pReplayGain.kill() ) emit sendOutput( i18n("Killed!") );
        else emit sendOutput( i18n("Failed to kill replaygain, trying to stop...") );
    }
}

void Convert::cleanUp()
{
    QFile fFile;

    if( actFile.sFormat != "wav" && actFile.Convert.sOutputFormat != "wav" ) {
        fFile.setName( actFile.Convert.sWaveOutputFilename );
        if ( fFile.exists() ) {
            fFile.remove();
            sendOutput( QString("rm ").append(actFile.Convert.sWaveOutputFilename));
        }
    }
    if( bKilled ) {
        fFile.setName( actFile.Convert.sOutputFilename );
        if ( fFile.exists() ) {
            fFile.remove();
            sendOutput( QString("rm ").append(actFile.Convert.sOutputFilename));
        }
    }
}

void Convert::priorityChanged(int newPriority)
{
    int pid=0;

    if( pDecode.isRunning() ) {
        pid=pDecode.pid();
    }
    else if( pEncode.isRunning() ) {
        pid=pEncode.pid();
    }
    else if( pReplayGain.isRunning() ) {
        pid=pReplayGain.pid();
    }

    if( pid == 0 ) return;

    char cprio[16], cpid[16];
    char cmd[32];
    KProcess pChangePriority;
    pChangePriority.clearArguments();

    KUser user;
    if( newPriority < priority && user.loginName() != "root" ) {
        pChangePriority << "kdesu";
        sprintf( cmd, "renice %i %i", newPriority, getpid() );
        pChangePriority << cmd;
        pChangePriority << "&&";
        sprintf( cmd, "renice %i %i", newPriority, pid );
        pChangePriority << cmd;
    }
    else {
        sprintf( cmd, "renice %i %i", newPriority, getpid() );
        pChangePriority << cmd;
        pChangePriority << "&&";
        pChangePriority << "renice";
        sprintf( cprio, "%i", newPriority );
        pChangePriority << cprio;
        sprintf( cpid, "%i", pid );
        pChangePriority << cpid;
    }

    priority=newPriority;

    pChangePriority.start( KProcess::DontCare );
}

