

#ifndef _COMBOBUTTON_H_
#define _COMBOBUTTON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class QString;
class QPixmap;
class KPushButton;
class KComboBox;

/**
 * @short ComboButton
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ComboButton : public QWidget
{
    Q_OBJECT
public:
    enum SizeMode {
        Min, Max
    };

    /**
     * Default Constructor
     */
    ComboButton(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~ComboButton();

    void insertItem(const QString &text, int index = -1);
    void insertItem(const QPixmap &pixmap, const QString &text, int index = -1);

    void setSizeMode(int mode);
    int sizeMode();

public slots:
    //void setCurrentItem(const QString &item, bool insert=false, int index=-1);
    //void setCurrentItem(int index);

signals:
    void clicked(int index);

private slots:
    void boxActivated(int index);
    void buttonClicked();

private:
    KPushButton *m_button;
    KComboBox *m_box;

    int m_sizeMode;

    void balanceSize();
    void repaintButton();

};

#endif // _COMBOBUTTON_H_
