/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <bonobo.h>
#include <gnome.h>

#include <dvd.h>

#include "preferences.h"
#include "app.h"
#include "pipe.h"

gpointer
pipe_thread_func		(gpointer	data)
{
	PipeHandle *handle;
	guint8 buf[512];
	ssize_t bytes;
	guint written_mbytes = 0;
	guint written_bytes = 0;
	gfloat percent = 0.0;

	handle = (PipeHandle *) data;
	
	bytes = read (handle->read_fd, buf, 512);
	while (bytes > 0) {
		ssize_t total_written = 0;
		gdouble calc_percent;
		
		while (total_written < bytes) {
			ssize_t written;
			
			written = write (handle->write_fd, &buf, bytes - total_written);
			if (written == -1) {
				g_warning ("error writing to process");
				g_thread_exit (NULL);
			} else {
				total_written += written;
			}
		}
		written_bytes += total_written;
		while (written_bytes >= 0x100000) {
			++written_mbytes;
			written_bytes -= 0x100000;
		
			calc_percent = (gdouble) written_mbytes / handle->read_mbs;
			if (calc_percent >= percent + 0.01) {
				percent = calc_percent;
				if (percent > 1.0) percent = 1.0;
				if (percent < 0.0) percent = 0.0;
				handle->func (NULL, percent);
			}
		}
		bytes = read (handle->read_fd, buf, 512);
	}
	g_thread_exit (NULL);
	return NULL;
}

gpointer
pipe_file_thread_func		(gpointer	data)
{
	PipeHandle *handle;
	guint8 buf[512];
	ssize_t bytes;

	handle = (PipeHandle *) data;
	
	bytes = read (handle->read_fd, buf, 512);
	while (bytes > 0) {
		ssize_t total_written = 0;
		
		while (total_written < bytes) {
			ssize_t written;
			
			written = write (handle->write_fd, &buf, bytes - total_written);
			if (written == -1) {
				g_warning ("error writing to process");
				g_thread_exit (NULL);
			} else {
				total_written += written;
			}
		}
		bytes = read (handle->read_fd, buf, 512);
	}
	g_thread_exit (NULL);
	return NULL;
}
