/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-disk.h DvdDisk object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DISK_H__
#define __DVD_DISK_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DISK_TYPE		(dvd_disk_get_type())
#define DVD_DISK(o)		(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DISK_TYPE, DvdDisk))
#define DVD_DISK_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DISK_TYPE, DvdDiskClass))
#define DVD_IS_DISK(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DISK_TYPE))
#define DVD_IS_DISK_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DISK_TYPE))

/* --- typedefs & structures --- */
/** Object representing a DVD disk video */
typedef struct	_DvdDisk	DvdDisk;
/** Object class representing a DVD disk video */
typedef struct	_DvdDiskClass	DvdDiskClass;
typedef struct	_DvdDiskVts	DvdDiskVts;

struct _DvdDiskVts {
	guint32	 ifo_blocks;
	guint32	 vts_menu_blocks;
	guint32	 vts_blocks;
};
	
struct _DvdDisk {
	Dvd		  parent;

	gchar		 *device;
	guint16		  vts_count;	/* including VIDEO_TS */
	DvdDiskVts	 *vts;
	guint32		  blocks;
	guint32		  backup_block;
	DvdMedia	  media;
	guint8		  percent;
	
	/* USED FOR FULL BACKUPS */
	GMutex		*backup_mutex;
	gboolean	 backing_up;
	gboolean	 backup_canned;
};

struct _DvdDiskClass {
	DvdClass	parent;
	
	void (*backup_progress)	(DvdDisk	*disk,
				 guint8		 percent);
};

/* --- prototypes --- */
GType		dvd_disk_get_type	 (void);
DvdDisk*	dvd_disk_new		 (void);
gboolean	dvd_disk_read_properties (DvdDisk       *dvd_disk,
					  const gchar   *device,
					  GError       **error);
gchar*		dvd_disk_backup		 (DvdDisk       *dvd_disk,
					  const gchar	*path,
					  GError       **error);
void		dvd_disk_stop_backup	 (DvdDisk       *dvd_disk);


G_END_DECLS

#endif /*__DVD_DISK_H__*/
