function libn=ilib_for_link(names,files,libs,flag,makename,loadername,libname,ldflags,cflags,fflags,cc)
// Generate a shared library which can be used by link 
// command. 
// names = names of entry points or the name of the library to 
// be built (when flag == 'g') 
// files = object files to be built 
// flag = 'c' or 'f' or '
// 
  [lhs,rhs]=argn(0);
  info=1
  if rhs <= 4 then makename = 'Makelib';end
  if rhs <= 5 then loadername = 'loader.sce';end
  if rhs <= 6 then libname = ""; end
  if rhs <= 7 then ldflags = ""; end 
  if rhs <= 8 then cflags  = ""; end 
  if rhs <= 9 then fflags  = ""; end 
  if rhs <= 10 then cc  = ""; end 
  // generate a loader file
  if info==1 then write(%io(2),'   generate a loader file');end
  
  ilib_link_gen_loader(names,flag,loadername,libs,libname);
  // generate a Makefile
  if info==1 then write(%io(2),'   generate a Makefile: Makelib');end
  ilib_link_gen_Make(names,files,libs,makename,libname,...
		     ldflags,cflags,fflags,cc);
  // we call make
  if info==1 then write(%io(2),'   running the makefile');end
  if libname=="" then libname = names(1);end
  libn=ilib_compile('lib'+libname,makename,files);
endfunction

function ilib_link_gen_loader(names,flag,loadername,libs,libname)
//------------------------------------
  if rhs <= 4 then libname = ""; end 
  if rhs <= 3 then libs=[]; end 
  if rhs <= 2 then loadername = 'loader.sce' ; end 
  comp_target = COMPILER;
  // suffix to be used for dll
  if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then lib_suf='dll';
     case 'ABSOFT' then lib_suf='dll';
    else lib_suf='dll';
    end
  else
     lib_suf=ilib_unix_soname();
  end
  
  if libname=="" then libname = names(1);end 
    
  fd=mopen(loadername,"w");
  mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"%s_path=get_absolute_file_path(''%s'');\n",libname,basename(loadername+'.x'));
  nl=size(libs,'*') 
  for i=1:nl 
    mfprintf(fd,"link(%s_path+''/%s.%s'');\n",libname,libs(i),lib_suf);
  end 
  mfprintf(fd,"link(%s_path+''/lib%s.%s'',[",libname,libname,lib_suf);
  names=names(:)';
  n = size(names,'*');
  for i=1:n
    mfprintf(fd,"''%s''",names(i))
    if i <>n ; mfprintf(fd,","); else mfprintf(fd,"],");end
  end
  mfprintf(fd,"''%s'');\n",flag);
  mclose(fd);
endfunction

function ilib_link_gen_Make(names,files,libs,makename,libname,ldflags,cflags,fflags,cc)
//------------------------------------
// generate a Makefile for gateway
  [lhs,rhs]=argn(0);
  if rhs <= 2 then libs = [];end
  if rhs <= 3 then makename = 'Makelib';end
  if rhs <= 4 then libname = "";end
  if rhs <= 5 then ldflags = ""; end 
  if rhs <= 6 then cflags  = ""; end 
  if rhs <= 7 then fflags  = ""; end 
  if rhs <= 8 then cc  = ""; end 
  comp_target = COMPILER;
  if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then Makename = makename+'.mak'
      ilib_link_gen_Make_win32(names,files,libs,Makename,libname,...
			       ldflags,cflags,fflags,cc)
     case 'ABSOFT' then Makename = makename+'.amk'
      ilib_link_gen_Make_win32(names,files,libs,Makename,libname,...
			       ldflags,cflags,fflags,cc)
     case 'gcc' then 
      // cygwin assumed 
      Makename = makename;
      ilib_link_gen_Make_unix(names,files,libs,Makename,libname,...
			      ldflags,cflags,fflags,cc)
    else 
       Makename = makename;
       ilib_link_gen_Make_win32(names,files,libs,Makename,libname,...
				ldflags,cflags,fflags,cc)
    end
  else
     Makename = makename;
     ilib_link_gen_Make_unix(names,files,libs,Makename,libname,...
			     ldflags,cflags,fflags,cc)
  end
endfunction

function ilib_link_gen_Make_unix(names,files,libs,Makename,libname, ...
				 ldflags,cflags,fflags,cc)
  
  if libname=="" then libname = names(1);end 
    
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SCIDIR = %s\n",SCI);
  mfprintf(fd,"OBJS = ")
  for x=files(:)' ; mfprintf(fd," %s",x);end
  mfprintf(fd,"\n") ;
  mfprintf(fd,"OTHERLIBS = ")
  for x=libs(:)' ; mfprintf(fd," %s",x);end
  mfprintf(fd,"\n") ;
  mfprintf(fd,"LIBRARY = lib%s\n",libname);
  mfprintf(fd,"include $(SCIDIR)/Makefile.incl\n");
  if cc<>"" then 
    mfprintf(fd,"CC="+cc+ "\n");
  end
  if getenv('WIN32','NO')=='OK' then
    // cygwin 
    mfprintf(fd,"OTHERLIBS = ");
    for x=libs(:)' ; mfprintf(fd," %s.a",x);end
    mfprintf(fd,"\n");
    mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
    mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	     " -Dmexfunction=mex$* "+ fflags +"\n"); 
  else
     mfprintf(fd,"CFLAGS = $(CC_OPTIONS) "+cflags+ "\n");
     mfprintf(fd,"FFLAGS = $(FC_OPTIONS) "+fflags+ "\n");
  end
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+ "\n");
  if getenv('WIN32','NO')=='OK' then
    // cygwin assumed : we use a specific makedll 
    // and not libtool up to now XXX 
    mfprintf(fd,"include $(SCIDIR)/config/Makecygdll.incl\n");
  else
     mfprintf(fd,"include $(SCIDIR)/config/Makeso.incl\n");
  end
  mclose(fd);
endfunction

function ilib_link_gen_Make_win32(names,files,libs,Makename,libname,ldflags, ...
				  cflags,fflags,cc)
  
  if libname=="" then libname = names(1);end 
  fd=mopen(Makename,"w");
  mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"# ------------------------------------------------------\n");
  mfprintf(fd,"SHELL = /bin/sh\n");
  mfprintf(fd,"SCIDIR =%s\n",SCI);
  mfprintf(fd,"SCIDIR1 =%s\n",WSCI);
  mfprintf(fd,"# name of the dll to be built\n"); 
  mfprintf(fd,"LIBRARY = lib%s\n",libname);
  mfprintf(fd,"# list of objects file\n");
  mfprintf(fd,"OBJS =");
  for x=files(:)' ; mfprintf(fd," %s",strsubst(x,".o",".obj"));end
  mfprintf(fd,"\n# added libraries \n");
  mfprintf(fd,"OTHERLIBS = ");
  for x=libs(:)' ; mfprintf(fd," %s.ilib",x);end
  mfprintf(fd,"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\Makefile.incl.mak\n");
  if cc<>"" then 
    mfprintf(fd,"CC="+cc+ "\n");
  end
  mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction_=mex$*_  -DmexFunction=mex_$* "+ cflags +" \n"); 
  mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -DFORDLL -I\""$(SCIDIR)/routines\"""+...
	   " -Dmexfunction=mex$* "+ fflags +"\n"); 
  mfprintf(fd,"EXTRA_LDFLAGS = "+ ldflags+"\n");
  mfprintf(fd,"!include $(SCIDIR1)\\config\\Makedll.incl \n");
  mclose(fd);
endfunction





