/*
 * wxrtoolbar.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __FF_WX_RTOOLBAR__
#define __FF_WX_RTOOLBAR__

// a simple extension of wxToolbar which can manage 1 (one) tool on its right side

#include <wx/toolbar.h>

class wxxRToolBar : public wxToolBar {
public:
	wxxRToolBar();
	wxxRToolBar(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style = wxTB_HORIZONTAL | wxNO_BORDER, 
		const wxString& name = wxPanelNameStr);
	/// Sets the tool which is to be displayed on the right side of the toolbar. 
	/// You should call this before Realize().
	/// @param toolId Which tool. If -1, no tool is displayed on the right side. 
	void SetRTool(int toolId);

	void OnSize(wxSizeEvent& event);
private:
	int rToolId;
};







#endif // FILE

