/*
 * wxext.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WXX_WXEXT_H__
#define __WXX_WXEXT_H__

// fwd declares
class wxString;
class wxFrame;
class wxSizer;
class wxToolBar;

/** @param location Can be either a file name or an URL.
  * @param defaultCmd The default browser command, if none is stored in the config as "BrowserCmd".
  *                   This is never used in MSW.
  */
bool wxxShowInBrowser(const wxString& location, const wxString& defaultCmd = wxT("netscape"));

/** Gets the file size for a given file, or -1 if it doesn't exist. 
  * @param file The file to check.
  */
wxLongLong wxxFileSize(const wxString& file);

/** Adds the toolbar to the given parent window within the current parentSizer. 
  * Under wxGTK only, adds an additional close button on the right side of the toolbar. 
  * This behaviour is useful if closeW is a MDI child frame (which is a Notebook tab on GTK). 
  * @param parent The parent window of the button
  * @param closeW The window to be closed when the button is clicked
  * @param parentSizer The sizer to which the button should be added
  * @param bar The toolbar which will be added
  * @param closeFunc Function of the class of closeW which will be called to close it
  */
void wxxAddCloseBar(wxWindow* parent, wxWindow* closeW, wxSizer* parentSizer, 
					wxToolBar* bar, wxCommandEventFunction closeFunc);

// wxConfig settings storage stuff
/// Stores a string
void wxxStoreString(const wxString& str, const wxString& cfgKey); 
/// Reads back a string
wxString wxxReadString(const wxString& def, const wxString& cfgKey); 

/// Stores a window rectangle
void wxxStoreRect(wxWindow* win, const wxString& cfgKey);
/// Reads back a window rectangle
void wxxRestoreRect(wxWindow* win, const wxString& cfgKey);


// //////////////////////////////////////////////
/// A MDI child frame which automatically stores its size, among other things. 
class wxxMDIChildFrame : public wxMDIChildFrame {
public:
	bool Destroy(); 

protected:
	wxxMDIChildFrame(wxMDIParentFrame* parent, const wxString& title, const wxString& cfgID, long style = wxDEFAULT_FRAME_STYLE);
	void RestoreRect(); 
	void StoreRect(); 
	void OnSize(wxSizeEvent& evt); 

	const wxString cfgID; 
}; 




#endif
