/*
 * reportdata.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WX_REPORTDATA_H__
#define __WX_REPORTDATA_H__

#include <wx/defs.h>
#include <wx/string.h>
#include <wx/listctrl.h>

class wxxReportCtrl;

enum wxxReportSpecialColumnWidths {
	wxREPORT_AUTOSIZE = -1,
	wxREPORT_AUTOSIZE_USEHEADER = -2,
	wxREPORT_AUTOGROW = -100 // grows proportionally with the reportctrl itself
};

enum wxxReportTextAlign {
	wxREPORT_LEFT = wxLIST_FORMAT_LEFT,
	wxREPORT_CENTER = wxLIST_FORMAT_CENTER,
	wxREPORT_CENTRE = wxLIST_FORMAT_CENTER,
	wxREPORT_RIGHT = wxLIST_FORMAT_RIGHT
};

enum wxxReportSortOrder {
	wxREPORT_ASCENDING = 1,
	wxREPORT_DESCENDING = -1
};

enum wxxReportDeleteMode {
	wxREPORT_DELNOTHING = 0,
	wxREPORT_DELELEMENTS = 1,
	wxREPORT_DELARRAY = 2,
	wxREPORT_DELALL = 3
};

class wxxReportColumnInfo
{
public:
	wxxReportColumnInfo(const wxString& title, int width, wxxReportTextAlign align = wxREPORT_LEFT) 
		: title(title), width(width), align(align) {}
	virtual ~wxxReportColumnInfo() {}
	
	wxString title;
	int width;
	wxxReportTextAlign align;
};

class wxxReportData 
{
public:
	virtual ~wxxReportData();

	virtual int GetColumnCount();
	virtual int GetColumnWidth(int col);
	virtual wxString GetColumnTitle(int col);
	virtual wxxReportTextAlign GetColumnAlign(int col);
	virtual int GetRowCount() = 0;
	// if you don't want an image, return -1 (wxxReportData's implementation always does that)
	virtual int GetImage(long row);
	virtual wxString GetItemText(long row, int col) = 0;
	virtual int CompareItems(long row1, long row2);

	inline void SetSortOrder(wxxReportSortOrder order) { sortOrder = order; }
	inline wxxReportSortOrder GetSortOrder() { return sortOrder; }
	inline void SetSortColumn(int col) { sortColumn = (col > GetColumnCount() ? -1 : col); }
	 // or -1 if unsorted
	inline int GetSortColumn() { return sortColumn; }
	virtual void SortItems();

protected:
	wxxReportData();
	// the image
	wxxReportData(int colCount, const wxxReportColumnInfo** infos, wxxReportDeleteMode delInfos = wxREPORT_DELELEMENTS);
	bool DoColumns();
	bool DoRows(int start = 0, int end = -1);

	const int colCount;
	const wxxReportColumnInfo** infos;

private:
	friend class wxxReportCtrl;

	wxxReportCtrl* ctrl;
	wxxReportDeleteMode delInfos;

	int sortColumn;
	wxxReportSortOrder sortOrder;
};

#endif
