/*
 * matrixview.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __ROBOTOP_MATRIXVIEW_H__
#define __ROBOTOP_MATRIXVIEW_H__

#include <wx/wx.h>

#include "dialogs.h"
#include "wxext.h" // bug fix

class MatrixWindow;
class TournamentFrame;
class TournamentEvent;

class MatrixFrame : public wxxMDIChildFrame
{
public:
	MatrixFrame(TournamentFrame* tour, wxMDIParentFrame* parent);
	~MatrixFrame();

	// event handlers (these functions should _not_ be virtual)
	void OnRedisplay(wxCommandEvent& event);
	void OnTourUpdate(TournamentEvent& event);
	void OnTourClose(TournamentEvent& event);
	void OnCloseCommand(wxCommandEvent& event);
	void OnCloseWindow(wxCloseEvent& event);

private:
	TournamentFrame* tour;
    wxMDIParentFrame* parent;
	MatrixWindow* matrix;

	wxMenuBar* CreateMenu();
	void InitToolBar(wxToolBar* toolBar);

	void Redisplay();

	// any class wishing to process wxWindows events must use this macro
	DECLARE_EVENT_TABLE();
};

enum { // command ids
	Matrix_Redisplay = 500
};

enum { // matrix constants
	MatrixWindowPrefSize = 450,
	MatrixWindowTextHalf = 120
};

class MatrixWindow : public wxControl
{
public:
	static inline int GetBitmapSize(const TourData& data);
	static inline int GetDotSize(const TourData& data);

	MatrixWindow(wxWindow* parent, const TourData& data);
	~MatrixWindow();

	void Recalculate();
	void Redisplay();
	bool IsCalculating();
	wxColour CalcColour(int wins, int losses, int ties);

	inline int GetDotSize();
	inline int GetBitmapSize();

	void Paint(wxDC& device, wxCoord maxX, wxCoord maxY);

	void OnPaint(wxPaintEvent& event);
	void OnMotion(wxMouseEvent& event);

	DECLARE_EVENT_TABLE();

private:
	enum {
		INVALID = -1
	};
	void WalkFiles(int** wins, int** losses, int** ties);
	void DrawBitmap(int** wins, int** losses, int** ties);
	
	TourData data;
	bool isCalculating;
	wxString altText;
	bool isDone;
	wxBitmap matrixBmp;
	wxArrayString botNames;

	wxCoord imgLeft, imgTop;
	int curX, curY;
	int** wins; int** losses; int** ties;
};



//////// inlines
int MatrixWindow::GetDotSize() { return GetDotSize(data); }
int MatrixWindow::GetDotSize(const TourData& data) { 
	return MatrixWindowPrefSize / data.chartSize; 
}
int MatrixWindow::GetBitmapSize() {	return GetBitmapSize(data); }
int MatrixWindow::GetBitmapSize(const TourData& data) {	
	return MatrixWindowPrefSize / data.chartSize * data.chartSize; 
}

#endif
