/*
 * dialogs.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __ROBOTOP_DIALOGS_H__
#define __ROBOTOP_DIALOGS_H__

#include <wx/wx.h>
#include <wx/spinctrl.h>

class wxxFselWindow;

// we'll need this convenience method again and again
extern wxString GetMainTourFolder();
// and this too 
// NOTE: that progName should be one of "robotour", "kickbot" etc. (it is, no extension!)
extern wxString GetProgramFileName(const wxString& progName);

// I don't really know why they haven't got this function
// simulates "dir spec" and puts results to store (which is emptied first).
extern void wxDirCommand(wxArrayString& store, const wxChar* spec, int flags = 0);

class GlobalPrefsDialog : public wxDialog
{
public:
	static GlobalPrefsDialog* Get();
	
	GlobalPrefsDialog(wxWindow* parent);
	~GlobalPrefsDialog();

	bool Go();
	void OnOK(wxCommandEvent& event);

	DECLARE_EVENT_TABLE();

private:
	wxxFselWindow* rtExeWin;
	wxxFselWindow* tourFolderWin;
#ifndef __WXMSW__ // where I don't need it
	wxxFselWindow* browserWin;
#endif
	wxCheckBox* soundWin;

	static GlobalPrefsDialog* instance;
};

enum TourPrefsMode {
	tourPrefsModeNew,
	tourPrefsModeChange
};

///////////////////////////////////////////
///////////////////////////////////////////
// Competition configuration data
class TourData
{
public:
	TourData(); // default construction
	TourData(const wxString& filename); // read-from-file construction
	~TourData();

	wxString tourName;
	wxString tourFile;
	wxString tourFolder;
	wxString optionSet;
	int chartSize;
	int numRepeats;

	bool Read();
	bool Save();
	bool Create(); // setups the dirs
};

///////////////////////////////////////////
class TourPrefsDialog : public wxDialog
{
public:
	// data is the TourData object which holds information about the competition.
	// You may just pass a new one if the dialog is launched in "New" mode. 
	// Note that it won't be deleted! (as the TourData*s normally belong to TourFrame)
	TourPrefsDialog(wxWindow* parent, TourPrefsMode mode, TourData* data);
	~TourPrefsDialog();

	bool Go();
	void OnOK(wxCommandEvent& event);

	void OnTourName(wxCommandEvent& event);
	void OnTourFile(wxCommandEvent& event);
	void OnOptionSet(wxCommandEvent& event);

	DECLARE_EVENT_TABLE();

private:
	wxTextCtrl* tourNameWin;
	wxStaticText* tourFileWin;
	wxWindow* tourFolderWin;
	wxStaticText* optionSetWin;
	wxSpinCtrl* chartSizeWin;
	wxSpinCtrl* numRepeatsWin;
	
	TourData* data;
	TourPrefsMode mode;
};

enum TourPrefsIDs {
	tpTourName = 1300,
	tpTourFile,
	tpOptionSet
};

#endif
