/*
 * rtmath.epoc.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// rtmath.epoc.cpp: Random implementation using Epoc System Libraries

#ifndef __LRT_MATH_EPOC__
#define __LRT_MATH_EPOC__

#include "rtmath.h"

#include <e32std.h>
#include <e32math.h>

namespace lrt {

TInt64 MATHseed;

int Math::rand(int from, int to)
{
	if(!randomInit) randomize();

	return (int)((float)(to - from + 1) * ::Math::Rand(MATHseed) / (::KMaxTInt + 1.0f)) + from;
}

void Math::seed(unsigned long seed)
{
	MATHseed = (TUint)seed;
	randomInit = true;
}

void Math::randomize()
{
	TTime t = TTime();
	t.HomeTime();	
	MATHseed = t.Int64();
	randomInit = true;
}


// FIXME: all those zero returns should be NaN but there seems to be no way to get it...
double Math::sqrt(double num)
{
	double res;
	if(::Math::Sqrt(res, num) < 0)
		return 0;
	else
		return res;
}

double Math::log10(double num)
{
	double res;
	if(::Math::Log(res, num) < 0)
		return 0;
	else
		return res;
}

double Math::ln(double num)
{
	double res;
	if(::Math::Ln(res, num) < 0)
		return 0;
	else
		return res;
}

double Math::exp(double num)
{
	::Math::Exp(num, num);
	return num;
}

double Math::sin(double num)
{
	::Math::Sin(num, num);
	return num;
}
double Math::cos(double num)
{
	::Math::Cos(num, num);
	return num;
}
double Math::tan(double num)
{
	if(::Math::Tan(num, num) < 0)
		return 0;
	return num;
}


} // namespace

#endif

