/*
 * rtiterator.templ.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __LRT_ITERATOR_TEMPL__
#define __LRT_ITERATOR_TEMPL__

#include "rtiterator.h"

namespace lrt {

template<class LRT_NPTR(T)> void deleteCurrent(Iterator<LRT_PTR(T)>& pos)
{
	if(!pos.canModify()) return;
	if(!pos.hasElement()) return;
	delete pos.get();
	pos.remove();
}

template<class LRT_NPTR(T)> void deleteAll(Iterator<LRT_PTR(T)> begin)
{
	if(!begin.canModify()) return;
	while(begin.hasElement()) {
		delete begin.get();
		begin.remove();
	}
}

}

#endif
