/*
 * rtchar.inline.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

////////// Inline member functions for class Char.

#ifndef __LRT_CHAR_INLINE__
#define __LRT_CHAR_INLINE__

namespace lrt {

inline bool Char::isSpace(char ch)
{
  if((unsigned char)ch <= (unsigned char)' ') return true;   // Ascii Control Chars & Whitespace
  if(((unsigned char)ch >= (unsigned char)0x7F) && 
	  ((unsigned char)ch <= (unsigned char)0xA0)) return true;  // Latin-1 Control Chars & NBSP
  return false;
}

inline bool Char::isUpperCase(char ch)
{
  if((ch <= 'Z') && (ch >= 'A')) return true;   // Ascii Uppercase Letters
  if(((unsigned char)ch >= (unsigned char)0xC0) && // Latin-1 Uppercase Letters
	  ((unsigned char)ch <= (unsigned char)0xDE) && ((unsigned char)ch != (unsigned char)0xD7)) return true;  
  return false;
}

inline bool Char::isLowerCase(char ch)
{
  if((ch >= 'a') && (ch <= 'z')) return true;   // Ascii Lowercase Letters
  if(((unsigned char)ch >= (unsigned char)0xDF) && 
	  ((unsigned char)ch != (unsigned char)0xF7)) return true;   // Latin-1 Lowercase Letters
  return false;
}

inline bool Char::isDigit(char ch)
{
	if((ch <= '9') && (ch >= '0')) return true;   // Ascii Numbers
	return false;
}

inline bool Char::isLetter(char ch)
{
	if(isLowerCase(ch) || isUpperCase(ch)) return true;
	return false;
}

inline char Char::lowerCase(char ch)
{
	if(isUpperCase(ch)) return (char)(ch + 32);
	return ch;
}

inline char Char::upperCase(char ch)
{
	//         Characters    Latin-1 ''    and    Latin-1 ''   have no uppercase equivalent
	if(isLowerCase(ch) && 
		((unsigned char)ch != (unsigned char)0xDF) && 
		((unsigned char)ch != (unsigned char)0xFF)) return (char)(ch - 32);
	return ch;
}

// Note that if ch is not a numeric character, results are undefined!
inline int  Char::numericValue(char ch)
{
	if(isDigit(ch)) return ch - '0';
	else return (lowerCase(ch) - 'a') + 10;
}

// Note that if num > MAX_RADIX, results are undefined!
inline char Char::charValue(int num)
{
	if(num < 10) return (char)(num + '0');
	else return (char)((num - 10) + 'A');
}

} // namespace
#endif

