/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import javax.swing.SwingUtilities;

/**
 * Based on ideas behind Sun's SwingWorker class.
 * http://java.sun.com/docs/books/tutorial/uiswing/misc/threads.html
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public abstract class Worker  {
	private Thread thread;

	public Worker()
	{
		final Runnable atFinish = new Runnable() {
			public void run()
			{
				finished();
			}
		};

		Runnable atConstruct = new Runnable() {
			public void run() {
				try {
					construct();
				} finally {
					// pass
				}

				SwingUtilities.invokeLater(atFinish);
			}
		};

		thread = new Thread(atConstruct);
	}

	public abstract Object construct();

	public abstract void finished();

	public void start()
	{
		thread.start();
	}
}
