/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include "config.h"
#include "qmailadmin.h"
#include <vpopmail.h>
#include <vauth.h>

char Username[MAX_BUFF];
char Domain[MAX_BUFF];
char Password[MAX_BUFF];
char Gecos[MAX_BUFF];
char Time[MAX_BUFF];
char ActionUser[MAX_BUFF];
char Newu[MAX_BUFF];
char Password1[MAX_BUFF];
char Password2[MAX_BUFF];
char Crypted[MAX_BUFF];
char Alias[MAX_BUFF];
char AliasType[MAX_BUFF];
char LineData[MAX_BUFF];
char Action[MAX_BUFF];
char Message[MAX_BIG_BUFF];
char StatusMessage[MAX_BIG_BUFF];
int num_of_mailinglist;
int CGIValues[256];
char Pagenumber[MAX_BUFF];
char SearchUser[MAX_BUFF];
time_t Mytime;
char *TmpCGI;
char TmpBuf[MAX_BIG_BUFF];
char TmpBuf1[MAX_BUFF];
char TmpBuf2[MAX_BUFF];
char TmpBuf3[MAX_BUFF];
char TempBuf[MAX_BUFF];
int Compressed;
FILE *actout;
FILE *lang_fs;
FILE *color_table;

int AdminType;
int MaxPopAccounts;
int MaxAliases;
int MaxForwards;
int MaxAutoResponders;
int MaxMailingLists;

int DisablePOP;
int DisableIMAP;
int DisableDialup;
int DisablePasswordChanging;
int DisableWebmail;
int DisableRelay;
char DefaultQuota[MAX_BUFF];

int CurPopAccounts;
int CurAliases;
int CurForwards;
int CurAutoResponders;
int CurMailingLists;
uid_t Uid;
gid_t Gid;
char RealDir[156];
char Lang[40];

void del_id_files( char *);

main(argc,argv)
 int argc;
 char *argv[];
{
 const char *u;
 const char *p;
 const char *ip_addr=getenv("REMOTE_ADDR");
 const char *x_forward=getenv("HTTP_X_FORWARDED_FOR");
 char *pi;
 int i,j;
 char *rm;
 time_t time1; 
 time_t time2;
 FILE *fs;
 int pid;

  init_globals();

  if (x_forward) ip_addr = x_forward;
  if (!ip_addr) ip_addr = "127.0.0.1";
  pi=getenv("PATH_INFO");
  if ( pi )  pi = strdup(pi);

  if (pi && strncmp(pi, "/com/", 5) == 0) {
    struct vqpasswd *pw;

    memset(TmpBuf2,0,MAX_BUFF);
    for(j=0,i=5;pi[i]!=0&&j<99;++i,++j) TmpBuf2[j] = pi[i];
    rm = getenv("REQUEST_METHOD");
    rm = strdup(rm);

    if ( strncmp(rm , "POST", 4) == 0 ) {
      get_cgi();
    } else {
      TmpCGI = (char *)getenv("QUERY_STRING");
      TmpCGI = strdup(TmpCGI);
    }

    GetValue(TmpCGI,Username, "user=",MAX_BUFF);
    GetValue(TmpCGI,Domain, "dom=",MAX_BUFF);
    GetValue(TmpCGI,Time, "time=",MAX_BUFF);
    Mytime = atoi(Time);
    pw = vauth_getpw( Username, Domain );

    /* get the real uid and gid and change to that user */
    vget_assign(Domain,RealDir,156,&Uid,&Gid);
    if ( geteuid() == 0 ) {
      if ( setegid(Gid) != 0 ) perror("setgid");
      if ( seteuid(Uid) != 0 ) perror("setuid");
    }

    if ( chdir(RealDir) < 0 ) {
      fprintf(stderr, "<h2>%s %s</h2>\n", get_html_text("171"), RealDir );
    }
    load_limits();

    set_admin_type();

    if ( AdminType == USER_ADMIN || AdminType == DOMAIN_ADMIN ) {
      auth_user_domain(ip_addr, pw);
    } else {
      auth_system(ip_addr, pw);
    }

    process_commands();

  } else if (pi && strncmp(pi, "/open/", 6) == 0) {
    memset(TmpBuf2,0,MAX_BUFF);
    for(j=0,i=6;pi[i]!=0&&j<99;++i,++j) TmpBuf2[j] = pi[i];
    rm = getenv("REQUEST_METHOD");
    rm = strdup(rm);

    if ( strncmp(rm , "POST", 4) == 0 ) {
      get_cgi();
    } else {
      TmpCGI = (char *)getenv("QUERY_STRING");
      TmpCGI = strdup(TmpCGI);
    }

    GetValue(TmpCGI,Username, "user=",MAX_BUFF);
    GetValue(TmpCGI,Domain, "dom=",MAX_BUFF);
    GetValue(TmpCGI,Time, "time=",MAX_BUFF);
    Mytime = atoi(Time);

    vget_assign(Domain,RealDir,156,&Uid,&Gid);
    if ( geteuid() == 0 ) {
      if ( setegid(Gid) != 0 ) perror("setgid");
      if ( seteuid(Uid) != 0 ) perror("setuid");
    }
    vclose();
    exit(0);
    

  } else {
   char *rm;
   struct vqpasswd *pw;
   FILE *fs;

     rm = getenv("REQUEST_METHOD");
     if ( rm ) rm = strdup(rm);

     if ( rm && strncmp(rm, "POST", 4) == 0 ) {
       get_cgi();

       GetValue(TmpCGI,Username, "username=",MAX_BUFF);
       GetValue(TmpCGI,Domain, "domain=",MAX_BUFF);
       GetValue(TmpCGI,Password, "password=",MAX_BUFF);

       vget_assign(Domain,RealDir,156,&Uid,&Gid);
       if ( geteuid() == 0 ) {
         if ( setegid(Gid) != 0 ) perror("setgid");
         if ( seteuid(Uid) != 0 ) perror("setuid");
       }

       /* Authenticate a user and domain admin */
       if ( strlen(Domain) > 0 ) {
         chdir(RealDir);
         load_limits();

         pw = vauth_user( Username, Domain, Password, "" );
         if ( pw == NULL ) { 
           sprintf(StatusMessage, "%s\n", get_html_text("198"));
           show_login();
           vclose();
           exit(0);
         }

         sprintf(TmpBuf, "%s/Maildir", pw->pw_dir);
         del_id_files( TmpBuf);

         Mytime = time(NULL);
         sprintf(TmpBuf, "%s/Maildir/%d.qw", pw->pw_dir, Mytime);
         fs = fopen(TmpBuf, "w");
         if ( fs == NULL ) {
           fprintf(actout,"%s %s<br>\n", get_html_text("144"), TmpBuf);
           vclose();
           exit(0);
         }
         fputs(ip_addr,fs);
         fclose(fs);
         vget_assign(Domain, TmpBuf1, MAX_BUFF, &Uid, &Gid);
         set_admin_type();
         show_menu(Username, Domain, Mytime);
         vclose();
         exit(0);
       }
     }
  }
  show_login();
  vclose();
}

init_globals()
{
 int i,j;
 int lang_err;
 struct vqpasswd *pw;
 char *tmpstr;
 char tmpbuf[40];

  memset(CGIValues, 0, sizeof(int));
  CGIValues['0'] = 0;
  CGIValues['1'] = 1;
  CGIValues['2'] = 2;
  CGIValues['3'] = 3;
  CGIValues['4'] = 4;
  CGIValues['5'] = 5;
  CGIValues['6'] = 6;
  CGIValues['7'] = 7;
  CGIValues['8'] = 8;
  CGIValues['9'] = 9;
  CGIValues['A'] = 10;
  CGIValues['B'] = 11;
  CGIValues['C'] = 12;
  CGIValues['D'] = 13;
  CGIValues['E'] = 14;
  CGIValues['F'] = 15;
  CGIValues['a'] = 10;
  CGIValues['b'] = 11;
  CGIValues['c'] = 12;
  CGIValues['d'] = 13;
  CGIValues['e'] = 14;
  CGIValues['f'] = 15;

  actout = stdout;
  memset(Username,0, MAX_BUFF);
  memset(Domain,0, MAX_BUFF);
  memset(Password,0, MAX_BUFF);
  memset(Time,0, MAX_BUFF);
  memset(ActionUser,0, MAX_BUFF);
  memset(Newu,0, MAX_BUFF);
  memset(Password1,0, MAX_BUFF);
  memset(Password2,0, MAX_BUFF);
  memset(Crypted,0, MAX_BUFF);
  memset(Alias,0, MAX_BUFF);
  memset(Message,0, MAX_BIG_BUFF);
  memset(TmpBuf,0, MAX_BIG_BUFF);
  memset(TmpBuf1,0, MAX_BUFF);
  memset(TmpBuf2,0, MAX_BUFF);
  memset(TmpBuf3,0, MAX_BUFF);

  AdminType = NO_ADMIN;

  lang_fs = NULL;

  memset((char *)tmpbuf, 0, 40);
  memset((char *)Lang, 0, 40);

  tmpstr = getenv("HTTP_ACCEPT_LANGUAGE");
  if ( tmpstr != NULL ) {
    strncpy(tmpbuf, tmpstr, 40);
    tmpstr = strtok(tmpbuf, " ,\n;");

    for(lang_err = -1;tmpstr!=NULL && lang_err==-1;) {
      lang_err = open_lang(tmpstr);
      if ( lang_err != -1 ) {
        strncpy(Lang, tmpstr, 40);
      } else {
        tmpstr = strtok(NULL, " ,\n;");
      }
    }

    if ( tmpstr == NULL ) strncpy(Lang, "en", 40);

  } else {
    strncpy(Lang, "en", 40);
  }

  if ( lang_fs == NULL ) {
    open_lang(Lang);
  }

  /* open the color table */
  open_colortable();

  umask(0077);

  fprintf(actout,"Content-Type: text/html\n");
#ifdef NO_CACHE
  fprintf(actout,"Cache-Control: no-cache\n"); 
  fprintf(actout,"Cache-Control: no-store\n"); 
  fprintf(actout,"Pragma: no-cache\n"); 
  fprintf(actout,"Expires: Thu, 01 Dec 1994 16:00:00 GMT\n");
#endif    
  fprintf(actout,"\n"); 
}

void del_id_files( char *dirname )
{
 DIR *mydir;
 struct dirent *mydirent;
 struct stat statbuf;

  mydir = opendir(dirname);
  if ( mydir == NULL ) return;

  while((mydirent=readdir(mydir))!=NULL){
    if ( strstr(mydirent->d_name,".qw")!=0 ) {
      sprintf(TmpBuf3, "%s/%s", dirname, mydirent->d_name);
      unlink(TmpBuf3);
    }
  }
  closedir(mydir);
}
