/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include <errno.h>
#include "config.h"
#include "qmailadmin.h"
#include "qmailadminx.h"

#define LIMIT_TOKENS " :\t\r\n"


load_limits()
{
 FILE *fs;
 char *tmpstr;

  MaxPopAccounts = DEFAULT_MAX_POP_USERS;
  MaxAliases = DEFAULT_MAX_ALIASES;
  MaxForwards = DEFAULT_MAX_FORWARDS;
  MaxAutoResponders = DEFAULT_MAX_AUTORESPONDERS;
  MaxMailingLists = DEFAULT_MAX_MAILINGLISTS;
  DisablePOP = 0;
  DisableIMAP = 0;
  DisableDialup = 0;
  DisablePasswordChanging = 0;
  DisableWebmail = 0;
  DisableRelay = 0;
  memset(DefaultQuota, 0, MAX_BUFF);

  if ( (fs=fopen(".qmailadmin-limits","r"))==NULL) {
    return(0);
  }

  while( fgets(TmpBuf, MAX_BUFF, fs) != NULL ) {
    tmpstr = strtok(TmpBuf, LIMIT_TOKENS);
    if ( tmpstr == NULL ) continue;

    if ( strncmp(tmpstr, "maxpopaccounts", 14 ) == 0 ) {
      tmpstr = strtok(NULL," :\t\n");
      if (tmpstr==NULL) continue;
      MaxPopAccounts = atoi(tmpstr);

    } else if ( strncmp(tmpstr, "maxaliases", 10 ) == 0 ) {
      tmpstr = strtok(NULL,LIMIT_TOKENS);
      if (tmpstr==NULL) continue;
      MaxAliases = atoi(tmpstr);

    } else if ( strncmp(tmpstr, "maxforwards", 11 ) == 0 ) {
      tmpstr = strtok(NULL,LIMIT_TOKENS);
      if (tmpstr==NULL) continue;
      MaxForwards = atoi(tmpstr);

    } else if ( strncmp(tmpstr, "maxautoresponders", 17 ) == 0 ) {
      tmpstr = strtok(NULL,LIMIT_TOKENS);
      if (tmpstr==NULL) continue;
      MaxAutoResponders = atoi(tmpstr);

    } else if ( strncmp(tmpstr, "maxmailinglists", 15 ) == 0 ) {
      tmpstr = strtok(NULL,LIMIT_TOKENS);
      if (tmpstr==NULL) continue;
      MaxMailingLists = atoi(tmpstr);

    } else if ( strncmp(tmpstr, "disable_pop", 11 ) == 0 ) {
      DisablePOP = 1;

    } else if ( strncmp(tmpstr, "disable_imap", 12 ) == 0 ) {
      DisableIMAP = 1;

    } else if ( strncmp(tmpstr, "disable_dialup", 14 ) == 0 ) {
      DisableDialup = 1;

    } else if (strncmp(tmpstr,"disable_password_changing",24)==0){
      DisablePasswordChanging = 1;

    } else if ( strncmp(tmpstr, "disable_webmail", 15 ) == 0 ) {
      DisableWebmail = 1;

    } else if (strncmp(tmpstr,"disable_external_relay",22)==0) {
      DisableRelay = 1;

    } else if ( strncmp(tmpstr, "default_quota", 13 ) == 0 ) {
      tmpstr = strtok(NULL," :\t\n");
      if (tmpstr==NULL) continue;
      strncpy(DefaultQuota, tmpstr, MAX_BUFF);
    }
  }
}
