/****************************************************************************
** UndoBuffer and UndoObject classes
**   Created : Saturday Jan 4'nd 2003
**        by : Varol Okan
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
****************************************************************************/
#ifndef QDVDAUTHORUNDOOBJECT_H
#define QDVDAUTHORUNDOOBJECT_H

#include <qpoint.h>
#include <undobuffer.h>

class QDVDAuthor;
// This class will encapsulate the Undo / redo Objects for the ConstructionArea - class
// Any UndoObject will hold only the most neccesary information for undo/redo functionality 
// to work, thus no complete FunctionPainter objects or other objects will be stored herein.
///////////////////////////////////////////////////////////////////////////////////////////

class QDVDAuthorUndoObject : public UndoObject
{
public:
	enum enUndoType {UNDEFINED = 0, NEW_FUNCTION, NEW_CONNECTION, DELETE_THING, ZOOM, PAN, GRID, MOVE};

	 QDVDAuthorUndoObject(enUndoType, float);
	 QDVDAuthorUndoObject(enUndoType, bool);
	 QDVDAuthorUndoObject(enUndoType, QPoint);
	virtual ~QDVDAuthorUndoObject();

	virtual void undo (QDVDAuthor *);
	virtual void redo (QDVDAuthor *);

	void updateDelta (int, int);
private:
	 QDVDAuthorUndoObject();

private:
	// Private member variables ...
	float	m_fZoom;
	bool	m_bGrid;
	QPoint	m_pointPanDelta;
	QPoint	m_pointPanStartPos;
};

#endif // QDVDAUTHORUNDOOBJECT_H


