/****************************************************************************
** Interface to the GUI.
**
**   Created : Sun Feb 23 21:45:00 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef OBJECTCOLLECTION_H
#define OBJECTCOLLECTION_H

#include <qpixmap.h>
#include "menuobject.h"

class MenuPreview;

class ObjectCollection : public MenuObject
{
  Q_OBJECT
  class Collection
  {
  public:
     Collection ( MenuObject *, bool b=true );
    ~Collection ( );
    MenuObject *pObject;
    bool bDeleteMe;
  };

public:
	// Public functions needed for the abstract base class.
	ObjectCollection (QWidget *pParent = 0);
	virtual ~ObjectCollection();
	virtual void drawContents          ( QPainter *   );
	virtual void drawContents          ( QPainter *, int, int);
	virtual bool mouseMoveEvent        ( QMouseEvent * );
	virtual bool mousePressEvent       ( QMouseEvent * );
	virtual bool mouseReleaseEvent     ( QMouseEvent * );
	virtual bool mouseDoubleClickEvent ( QMouseEvent * );

	virtual bool readProjectFile       ( QDomNode      & );
	virtual bool writeProjectFile      ( QDomElement   & );
	virtual bool createContextMenu     ( QPoint          );
	virtual StructureItem *createStructure ( StructureItem * );
	virtual MenuObject *clone          ( QWidget *p1=NULL, MenuObject *p2=NULL );
	virtual void setShadow             ( MenuObject *    );

public:
	int         getCount               ( );
	MenuObject *getObject              ( int );

	bool readObjects                   ( QDomNode &, MenuPreview * );
	void deleteAllObjects              ( bool);
	void append                        ( MenuObject *, bool b=true );
	void setObjects                    ( QValueList<MenuObject *> &, bool b=true );
	bool contains                      ( MenuObject * );
	void clear                         ( );

signals:
	void signalDefineAsButton          ( MenuObject * );

public slots:
	virtual void slotToFront           ( );
	virtual void slotToBack            ( );

protected slots:
	virtual void slotEdit              ( );
	virtual void slotDelete            ( );
	//	virtual void slotAddShadow         ( );
	virtual void slotAddFrame          ( );
	virtual void slotAddText           ( );
	virtual void slotAddImage          ( );
	virtual void slotAddMovie          ( );
	virtual void slotDefineAsButton    ( );

protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);
	QValueList<Collection *> m_listObjectCollection;
};

#endif	// OBJECTCOLLECTION_H

