/****************************************************************************
** Interface to the GUI.
**
**   Created : Tue 04 May 12:09:08 2004
**        by : Carol Akan using kate editor
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
** This are the classes for the StructureWidget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/

#ifndef STRUCTURETOOLBAR_H
#define STRUCTURETOOLBAR_H

#include <qdockwindow.h>
#include <qlistview.h>
#include <qsize.h>

#include "uistructurewidget.h"

class MenuPreview;
class MenuObject;
class DVDMenu;

class StructureItem : public QListViewItem
{
public:
  StructureItem ( MenuObject *pMenuObject, QListViewItem *pListViewItem, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem (pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( ); m_pMenuObject = pMenuObject; };

  StructureItem ( MenuObject *pMenuObject, QListViewItem *pParent, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pParent, pAfter, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( ); m_pMenuObject = pMenuObject; };

  StructureItem ( MenuPreview *pMenuPreview, QListViewItem *pListViewItem, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
      : QListViewItem (pListViewItem, pAfter, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( ); m_pMenuPreview = pMenuPreview; };

  StructureItem ( DVDMenu *pDVDMenu, QListViewItem *pListViewItem, QListViewItem *pAfter, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem (pListViewItem, pAfter, q1, q2, q3, q4, q5, q6, q7, q8) 
    { initMe ( ); m_pDVDMenu = pDVDMenu; };

  StructureItem ( QListViewItem *pListViewItem, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pListViewItem, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( ); };

  StructureItem ( QListView *pListView, QString q1=QString::null, QString q2=QString::null, QString q3=QString::null, QString q4=QString::null, QString q5=QString::null, QString q6=QString::null, QString q7=QString::null, QString q8=QString::null)
    : QListViewItem ( pListView, q1, q2, q3, q4, q5, q6, q7, q8 )
    { initMe ( ); };

    virtual ~StructureItem ( );
    virtual int rtti       ( ) const { return 5000; };

    void initMe  ( );
    void createContextMenu     ( QPoint );
    void createIntroExtroMenu  ( QPoint );
    void setText ( QString &, QString & );
    void setText ( int,       QString & );

    StructureItem  *setSibling ( MenuObject *,  StructureItem *, QString, QString );
    StructureItem  *setSibling ( DVDMenu *,     StructureItem *, QString, QString );
    StructureItem  *setSibling ( MenuPreview *, StructureItem *, QString, QString );
    StructureItem  *lastChild  ( );
    MenuObject  *getMenuObject ( ) { return m_pMenuObject; };

private:
    MenuObject  *m_pMenuObject;
    MenuPreview *m_pMenuPreview;
    DVDMenu     *m_pDVDMenu; // used or Intro / Extro ...
    static int RTTI;
};

class StructureToolBar : public QDockWindow
{
  Q_OBJECT

public:
  StructureToolBar ( const char *, QMainWindow * );
  virtual ~StructureToolBar   ( );

  StructureItem *clean   ( bool );

  virtual QSize sizeHint () const;

public slots:
  virtual void slotRightClickedOnStructure (QListViewItem *, const QPoint &, int);
  virtual void slotRightClickedOnTitleset  (QListViewItem *, const QPoint &, int);

private:
  uiStructureWidget *m_pStructureWidget;
};

#endif // STRUCTURETOOLBAR_H

