/*****************************************************************************
 ** After the User has selected and grouped all Images, and Videos, we'll have a list of groups.
 **
 ** To create a DVD structure from this list the following information should be provided.
 ** 
 ** General :
 **  - Plugin to use for DVD creation
 **  - type ( NTSC/PAL )
 **  - Max # menu buttons
 **  - Project Name
 **  - temp path 
 **
 ** Group :
 **  - Type ( Slideshow / Videos )
 **  - Name of the Group
 **  - Create Chapter menu(s) -yes/no-
 **  - Date from - to of material within the group
 **  - Source files
 **  - Audio File(s) for Slideshow
 **
 ** Source Files :  ( Slideshow already in VOB + Chapters )
 **  - File Name
 **  - Start Date - End Date
 **
 ** NOTE: Slideshow information is profided as video file(s). 
 **       I.e. The individual images are already converted int VOBs.
 **
 *****************************************************************************/

#ifndef __PLUGIN_SIMPLEDVD_H__
#define __PLUGIN_SIMPLEDVD_H__

#include <qvaluelist.h>

#include "../interface.h"

class uiControls;
class QProgressDialog;

namespace Plugin
{

class ComplexDVD : public Interface
{
  Q_OBJECT

public:
           ComplexDVD ( );
  virtual ~ComplexDVD ( );

  virtual QWidget *getConfigWidget ( QWidget * );
  virtual bool execute ( );

protected slots:
  virtual void slotInitTimer    ( );
  virtual void slotRandomImages ( bool );
  virtual void slotWPArchive    ( bool );
  virtual void slotHDRCreme     ( bool );

protected:
  QString getMenuXML     ( QValueList<SourceGroup *> &, int, int & );
  QString getMenuButtons ( bool, bool, int );
  QString getImgCmd      ( QString & );
  void    getRandomBackground ( );
  void    createMainMenu      ( );

  int             m_iNrOfMenus;
  uiControls     *m_pConfigWidget;
  QValueList<int> m_listNumberOfImages;
}; // end class SimpleDVD

};  // End namespace Plugin

#endif // __PLUGIN_SIMPLEDVD_H__
