/*****************************************************************************
 ** Class Import::Srt
 **
 ** This class handles the import filter for srt (subtitle) files
 **
 **   Created : 
 **        by : Varol Okan using kate editor
 ** Copyright : (c) Varol Okan
 **   License : GPL v 2.0
 **
 ** 2
 ** 00:00:27,480 --> 00:00:31,480
 ** Une production SAMULI TORSSONEN
 ** (adaptée de STAR TREK & BABYLON 5)
 **
 ** 3
 ** 00:00:42,400 --> 00:00:45,880
 ** Un film de TIMO VUORENSOLA
 ** SOUS-TITRAGE & TRADUCTION : Fred CORNEC
 **
 *****************************************************************************/

#ifndef __IMPORT_SRT_H__
#define __IMPORT_SRT_H__

#include "sourcefileentry.h"

namespace Import
{

class Srt
{
public:

public:
   Srt ( );
  ~Srt ( );

  bool    import      ( );
  bool    readFile    ( QString & );
  QString readEntry   ( QTextStream *, Subtitles::entry * );
  QString getFileName ( );

  QValueList<Subtitles::entry *> m_listOfEntries;
private:
  bool    isTimeStamp  ( QString &       );
  QString getTimeRange ( QString &, bool );
  long    getTimeFromString ( QString &  );

  QString m_qsFileName;
};

}

#endif // __IMPORT_SRT_H__
