#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QPaintEvent>
#include <QPixmap>
#include <QImage>

class Widget : public QWidget
{
    Q_OBJECT
public:
    Widget();
    QSize sizeHint() const;
protected:
    void paintEvent(QPaintEvent *e);

    void mousePressEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void wheelEvent(QWheelEvent *e);

    void enterEvent(QEvent * event);
    void leaveEvent(QEvent * event);

    void drawHelp(QPainter *p);
    void drawRadius(QPainter *p);

    void generateLens(const QRectF &bounds);
private:
    QList<QImage> m_images;
    int           m_current;

    QImage m_blurred;

    int  m_radius;
    
    QPixmap m_tile;
    bool m_mouseIn;
    bool m_mouseDown;

    QImage m_lens;
    
    QPointF m_pos;
};

#endif
