/****************************************************************************
** SelectionObject is being used in MenuPreview for multiple selections
**
** Created: Sun Mar 23 21:45:00 2006
**      by: Varol Okan using xemacs
**
**
****************************************************************************/

#ifndef SELECTIONOBJECT_H
#define SELECTIONOBJECT_H

#include "objectcollection.h"

class QPainter;

class SelectionObject : public ObjectCollection
{
  Q_OBJECT
  
public:
  // Public functions needed for the abstract base class.
  SelectionObject         ( QWidget *pParent=0 );
  virtual ~SelectionObject                   ( );
  
  void resetObjectStates                     ( );
  bool find                   ( MenuObject   * );
  bool mouseOver             ( const QPoint  & );
  void setMoveState                     ( bool );
  void setCurrentMousePos           ( QPoint & );
  virtual bool mousePressEvent ( QMouseEvent * );
  virtual bool createContextMenu      ( QPoint );

  virtual void drawContents       ( QPainter * );
  virtual void drawSelected       ( QPainter * );

};

#endif	// SELECTIONOBJECT_H

