/****************************************************************************
** SelectionObject class 
**
** Created: Tue Mar 02 22:06:51 2006
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ObjectCollection.
**
** The ObjectCollection is not yet finished. It is intended to hold a list
** of MenuObject's which are linked to each other. Meaning if you move 
** the collection each member of it will move the same extend.
**
** Another use is to create a template which will fit the images/movies
** into a fixed scheme.
**
****************************************************************************/

#include <qpen.h>
#include <qbrush.h>
#include <qpainter.h>
#include <qpopupmenu.h>

#include "menuobject.h"
#include "selectionobject.h"

SelectionObject::SelectionObject ( QWidget *pParent )
  : ObjectCollection ( pParent )
{
}

SelectionObject::~SelectionObject ( )
{
  resetObjectStates ( );
  clear ( );
}

void SelectionObject::resetObjectStates ( )
{
  uint t;
  for (t=0;t<m_listObjectCollection.count();t++)
    m_listObjectCollection[t]->pObject->setObjectState ( MenuObject::StateUnknown );
}

void SelectionObject::setMoveState ( bool bSetMoving )
{
  uint t;
  MenuObject::enState enState = MenuObject::StateMoveObject;
  if ( ! bSetMoving )
    enState = MenuObject::StateUnknown;

  for (t=0;t<m_listObjectCollection.count();t++) {
    m_listObjectCollection[t]->pObject->setObjectState ( enState );
    m_listObjectCollection[t]->pObject->setActive ( bSetMoving );
  }
}

void SelectionObject::setCurrentMousePos ( QPoint &thePos )
{
  uint t;
  for (t=0;t<m_listObjectCollection.count();t++) {
    m_listObjectCollection[t]->pObject->setCurrentMousePos ( thePos );
  }
}

void SelectionObject::drawSelected ( QPainter *pPainter )
{
  MenuObject *pObject;
  QWMatrix    theMatrix;
  QPoint      centerPos;
  //QPainter    thePainter ( parent () );
  QBrush      theBrush   ( QColor ( 100, 255, 100 ), Qt::Dense6Pattern );
  QPen        thePen     ( QColor ( 100, 255, 100 ), 1,  Qt::SolidLine );
  // Here we calculate the center point of gravity (rotation)
  uint t;
  for (t=0;t<m_listObjectCollection.count();t++) {
    pObject = m_listObjectCollection[t]->pObject;

    centerPos.setX (pObject->rect().x() + (int)((float)pObject->rect().width () / 2.0));
    centerPos.setY (pObject->rect().y() + (int)((float)pObject->rect().height() / 2.0));
    // Here we define the cenetered rect.
    QRect theRect ((int)-(pObject->rect().width()/ 2.0), (int)-(pObject->rect().height()/2.0), pObject->rect().width(), pObject->rect().height());
    
    // First we translate to the appropriate location,
    theMatrix.translate ((double)centerPos.x(), (double)centerPos.y());
    
    //. then we apply the other modifications ...
    theMatrix.scale  ( pObject->modifiers ( )->fScaleX, pObject->modifiers ( )->fScaleY );
    theMatrix.shear  ( pObject->modifiers ( )->fShearX, pObject->modifiers ( )->fShearY  );
    theMatrix.rotate ( pObject->modifiers ( )->fRotate );
  
    pPainter->setWorldMatrix(theMatrix);
    
    pPainter->setBrush ( theBrush );
    pPainter->setPen   (  thePen  );
    pPainter->drawRect (  theRect );
    
    theMatrix.reset();
  }
  pPainter->setWorldMatrix(theMatrix);  
}

void SelectionObject::drawContents ( QPainter *pPainter )
{
  drawSelected ( pPainter );
  //printf ( "SelectionObject::drawContents <%d>\n", (int)m_listObjectCollection.count() );
}

bool SelectionObject::find ( MenuObject *pObject )
{
  uint t;
  for (t=0;t<m_listObjectCollection.count();t++) {
    if ( m_listObjectCollection[t]->pObject == pObject ) 
      return true;
  }
  return false;
}

// returns if the mouse is within one of the selected objects
// AND sets the state accordingly
bool SelectionObject::mouseOver ( QPoint const &thePoint )
{
  uint t;
  for (t=0;t<m_listObjectCollection.count();t++) {
    if ( m_listObjectCollection[t]->pObject->boundingRect ().contains ( thePoint ) ) {
      setMoveState ( true );
      return true;
    }
  }
  setMoveState ( false );
  return false;
}

bool SelectionObject::mousePressEvent ( QMouseEvent *pEvent )
{
  uint t;
  if ( pEvent->button ( ) == RightButton ) {
    for (t=0;t<m_listObjectCollection.count();t++)  {
      if ( m_listObjectCollection [t]->pObject->boundingRect ( ).contains ( pEvent->pos ( ) ) ) {
	createContextMenu ( pEvent->globalPos ( ) );
	return true;
      }
    }
  }
  return false;
}

bool SelectionObject::createContextMenu ( QPoint globalPos )
{  
  if (m_pContextMenu)
    delete m_pContextMenu;
  m_pContextMenu = new QPopupMenu(m_pParent);
  m_pContextMenu->insertItem ( tr ("To Front"), this, SLOT(slotToFront ( ) ) );
  m_pContextMenu->insertItem ( tr ("To Back"),  this, SLOT(slotToBack  ( ) ) );
  m_pContextMenu->exec(globalPos, 1);
  
  if (m_pContextMenu)
    delete m_pContextMenu;
  m_pContextMenu = NULL;

  return true;
}
