/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef MOVIEOBJECT_H
#define MOVIEOBJECT_H

#include <qimage.h>
#include <qdatetime.h>
#include <qsize.h>

#include "imageobject.h"

class QTimer;

class DragNDropContainer;
class DVDMenu;

class MovieObject : public ImageObject
{
	Q_OBJECT
public:
	MovieObject                     ( QWidget *pParent=0 );
	virtual ~MovieObject            ( );

	virtual void drawContents       ( QPainter *, int, int );
	virtual bool readProjectFile    ( QDomNode & );
	virtual bool writeProjectFile   ( QDomElement & );
	virtual void createStructure    ( QListViewItem * );
	virtual bool createContextMenu  ( QPoint );
	virtual MenuObject *clone       ( );

	virtual void setPixmap          ( QPixmap & );
	virtual void updatePixmap       ( );

	void     setStartAfterDropEvent ( bool   );
	void     setExtracted           ( bool   );
	void     setDVDMenu             ( DVDMenu *, bool b=false);
	void     setOffset              ( QTime &);
	void     setDuration            ( QTime &);
	void     setMSecPreview         ( long   );
	void     setNiceness            ( int    );
	void     setMovieSize           ( QSize &);
	QTime   &offset                 ( );
	QTime   &duration               ( );
	long     msecPreview            ( );
	QSize   &movieSize              ( );
	QImage  *previewImage           ( );
	DVDMenu *dvdMenu                ( );

	void    setDragNDropValues      ( DragNDropContainer *);
	void    registerToRender        ( );

protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);
	virtual void timerEvent         ( QTimerEvent *);	// called after the preview has been rendered in a child task.
	void loadPixmap                 ( QString);

public slots:
	virtual void slotStartConverting( );

protected slots:
	virtual void slotEdit           ( );
	virtual void slotProperties     ( );
	virtual void slotSetThumbnail   ( long );

/* Handled in base class ImageObject
	virtual void drawContents(QPainter *);
	virtual bool mousePressEvent       (QMouseEvent *);
	virtual bool mouseReleaseEvent     (QMouseEvent *);
	virtual bool mouseDoubleClickEvent (QMouseEvent *);
	
	QString m_qsFileName;
	QPixmap m_pixmap;
	ImageManipulator m_imageManipulator;
*/

protected:
	DVDMenu *m_pDVDMenu;
	bool     m_bExtracted;
	QSize    m_sizeOriginalMovieSize;
	long     m_iMSecPreview;
	QTime    m_timeOffset;
	QTime    m_timeDuration;
	QImage   m_imagePreview;	// used to create a preview in a background task.
	int      m_iHowNiceShouldIBe;
	bool     m_bStartAfterDropEvent;
	QTimer  *m_pConvertTimer;
};

#endif	// MOVIEOBJECT_H
