/****************************************************************************
** DialogShadow - class
**
** Created: Thu Aug 3 22:05:18 2006
**      by: Varol Okan Using XEmacs
**
****************************************************************************/

#ifndef DIALOGSHADOW_H
#define DIALOGSHADOW_H

#include "uidialogshadow.h"

class ShadowObject;
class QScrollView;
class ImageObject;
class MenuObject;
class QPixmap;
class QLabel;

class DialogShadow : public uiDialogShadow
{
  Q_OBJECT
public:
   DialogShadow ( QWidget *p=0, const char *n=0, bool m=false, WFlags fl=0 );
  ~DialogShadow ( );

  void initMe ( MenuObject *, QPixmap * );

protected:
  void drawShadow ( );
  void refresh    ( );

protected slots:
  virtual void accept               ( );
  virtual void reject               ( );
  virtual void slotCenterScrollView ( );
  virtual void slotShadowColor      ( );
  virtual void slotTransparency ( int );
  virtual void slotDistance     ( int );
  virtual void slotSunAngle     ( int );
  virtual void slotBlur         ( int );

private:
  void keepStaticVariables ( );
  void setStaticVariables  ( );

private:
  QPixmap      *m_pBackground;
  ShadowObject *m_pShadow;
  ShadowObject *m_pOrigShadow; // stores the original shadow in case we click cancel.
  MenuObject   *m_pMenuObject;
  QLabel       *m_pPreview;
  QScrollView  *m_pScrollView;

  // static vars to keep the current values for the shadow
  // this way the user does not always have to start from square one.
  static int    m_keepBlurRadius;
  static float  m_keepTransparency;
  static float  m_keepDistance;
  static float  m_keepSunAngle;
  static QColor m_keepColor;
};

#endif // DIALOGSHADOW_H
