/****************************************************************************
** ImagePreview class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ImagePreview from the FileSelection
** Dialog.
** It is also used in the ImageDialog.
**
****************************************************************************/

#include <qfile.h>
#include <qpainter.h>
#include <qpopupmenu.h>

#include "xml_dvd.h"
#include "menuobject.h"

MenuObject::MenuObject (QWidget *pParent)
	: QObject (pParent)
{
	m_qsObjectType = QString (MENU_OBJECT);
	m_pParent      = pParent;
	m_bDrawRect    = false;
	m_pContextMenu = NULL;
}

MenuObject::~MenuObject ()
{
	uint t;
	if (m_pContextMenu)
		delete m_pContextMenu;
	m_pContextMenu = NULL;
	for (t=0;t<m_listAnimationAttributes.count();t++)	{
		delete m_listAnimationAttributes[t];
	}
	m_listAnimationAttributes.clear();
}

// Need to take m_rectPreview into accoutn ...
bool MenuObject::contains (QPoint &pos)
{
	if (!m_boundingRect.contains(pos))
		return false;
	return true;
}

bool MenuObject::readProjectFile  (QDomNode &theNode)
{
	// Here we read in the base class ...
	QDomNode subNode;
	QDomNode xmlMenuObject = theNode.firstChild();

	while ( !xmlMenuObject.isNull () )	{
		// Okay, here we retain the stored data from the xml file.
		QDomAttr attribute;
		QDomElement theElement = xmlMenuObject.toElement();
		QString tagName = theElement.tagName();
		QString nodeText = theElement.text ();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (tagName == MENU_OBJECT)	{
			m_qsName = nodeText;
			QRect theRect;
			int iX, iY, iWidth, iHeight;
			iX      = rect().x();
			iY      = rect().y();
			iWidth  = rect().width();
			iHeight = rect().height();

			attribute = theElement.attributeNode ( MENU_OBJECT_NAME );
			if (!attribute.isNull())
				m_qsName = attribute.value();

			attribute = theElement.attributeNode ( MENU_OBJECT_EXTRACTION_PATH );
			if (!attribute.isNull())
				m_qsExtractionPath = attribute.value();

			attribute = theElement.attributeNode ( RECT_X );
			if (!attribute.isNull())
				iX = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_Y );
			if (!attribute.isNull())
				iY = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_WIDTH );
			if (!attribute.isNull())
				iWidth = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_HEIGHT );
			if (!attribute.isNull())
				iHeight = attribute.value().toInt();

			theRect = QRect (iX, iY, iWidth, iHeight);
			setRect(theRect);

			subNode = xmlMenuObject.firstChild ();
			while ( ! subNode.isNull () )	{
				theElement = subNode.toElement();
				tagName = theElement.tagName  ();
				if (tagName == MODIFIERS)	{
					attribute = theElement.attributeNode ( MODIFIERS_ROTATE );
					if (!attribute.isNull())
						modifiers()->fRotate = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_TRANSPARENCY );
					if (!attribute.isNull())
						modifiers()->fTransparency = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_ZOOM );
					if (!attribute.isNull())
						modifiers()->fZoom = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_SCALEX);
					if (!attribute.isNull())
						modifiers()->fScaleX = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_SCALEY );
					if (!attribute.isNull())
						modifiers()->fScaleY = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_SHEARX );
					if (!attribute.isNull())
						modifiers()->fShearX = attribute.value().toFloat();

					attribute = theElement.attributeNode ( MODIFIERS_SHEARY );
					if (!attribute.isNull())
						modifiers()->fShearY = attribute.value().toFloat();
				}
				else if (tagName == ANIMATION_OBJECT)	{
					m_qsAnimation = theElement.text ();
				}
				subNode = subNode.nextSibling ();
			}
		}
		// So lets get the next sibling ... until we hit hte end of DVDMenu ...
		xmlMenuObject = xmlMenuObject.nextSibling();
	}
	return true;
}

// <...>
// <MenuObject Name="the Name" X="" Y="" Width="" Height="">
//		<Modifiers Rotate="" Zoom="" ScaleX="" ScaleY="" ShearX="" ShearY=""></Modifiers>
// </MenuObject>
// </...>
bool MenuObject::writeProjectFile (QDomElement &theElement)
{
	// First check if this node holds any information at all ...
//printf ("MenuObject::writeProjectFile <%s><%s>\n",(const char *)theElement.tagName(), (const char *)name());
	QDomDocument xmlDoc = theElement.ownerDocument();
	QDomElement objectNode = xmlDoc.createElement( MENU_OBJECT );	// <MenuObject>
	// Here we set the attributes of the <dvdauthor> tag
	if (!name().isNull())
		objectNode.setAttribute( MENU_OBJECT_NAME, name() );
	if (!extractionPath().isNull())
		objectNode.setAttribute( MENU_OBJECT_EXTRACTION_PATH, extractionPath() );
	objectNode.setAttribute( RECT_X, rect().x() );
	objectNode.setAttribute( RECT_Y, rect().y() );
	objectNode.setAttribute( RECT_WIDTH,  rect().width () );
	objectNode.setAttribute( RECT_HEIGHT, rect().height() );
	// And now proceed to writing the Modifiers ... If we need that is ...
	Modifiers initialValues;
	if (	(modifiers()->fRotate != initialValues.fRotate) || (modifiers()->fShearX != initialValues.fShearX)  || 
		(modifiers()->fShearY != initialValues.fShearX) || (modifiers()->fZoom != initialValues.fZoom)      || 
		(modifiers()->fScaleX != initialValues.fScaleX) || (modifiers()->fScaleY != initialValues.fScaleY)  ||
		(modifiers()->fTransparency != initialValues.fTransparency) )	{

		QDomElement modifiersNode = xmlDoc.createElement ( MODIFIERS );
		if (modifiers()->fRotate != initialValues.fRotate)
			modifiersNode.setAttribute( MODIFIERS_ROTATE, QString ("%1").arg(modifiers()->fRotate) );
		if (modifiers()->fShearX != initialValues.fShearX)
			modifiersNode.setAttribute( MODIFIERS_SHEARX, QString ("%1").arg(modifiers()->fShearX) );
		if (modifiers()->fShearY != initialValues.fShearY)
			modifiersNode.setAttribute( MODIFIERS_SHEARY, QString ("%1").arg(modifiers()->fShearY) );
		if (modifiers()->fZoom != initialValues.fZoom)
			modifiersNode.setAttribute( MODIFIERS_ZOOM  , QString ("%1").arg(modifiers()->fZoom) );
		if (modifiers()->fScaleX != initialValues.fScaleX)
			modifiersNode.setAttribute( MODIFIERS_SCALEX, QString ("%1").arg(modifiers()->fScaleX) );
		if (modifiers()->fScaleY != initialValues.fScaleY)
			modifiersNode.setAttribute( MODIFIERS_SCALEY, QString ("%1").arg(modifiers()->fScaleY) );
		if (modifiers()->fTransparency != initialValues.fTransparency)
			modifiersNode.setAttribute( MODIFIERS_TRANSPARENCY, QString ("%1").arg(modifiers()->fTransparency) );
		objectNode.appendChild( modifiersNode );
	}
	if ( ! m_qsAnimation.isEmpty())	{
		QDomElement animationNode = xmlDoc.createElement( ANIMATION_OBJECT );	// <AnimationObject>
		QDomText text = xmlDoc.createTextNode ( m_qsAnimation );
		animationNode.appendChild ( text );
		objectNode.appendChild ( animationNode );
	}
	theElement.appendChild( objectNode );
	return true;
}

void MenuObject::update()
{
	QPainter thePainter(parent());
	QRect theRect = boundingRect();
	theRect.addCoords(-5, -5, 5, 5);
	parent()->repaint(theRect, FALSE);
	drawContents(&thePainter);

//	emit(signalUpdatePixmap());
}

QString &MenuObject::objectType()
{
	return m_qsObjectType;
}

QString &MenuObject::name()
{
	return m_qsName;
}

QString &MenuObject::extractionPath()
{
	return m_qsExtractionPath;
}

QString &MenuObject::animation()
{
	return m_qsAnimation;
}

Modifiers *MenuObject::modifiers()
{
	return &m_modifiers;
}

void MenuObject::setModifiers(Modifiers &theModifiers)
{
	modifiers()->fRotate       = theModifiers.fRotate;
	modifiers()->fZoom         = theModifiers.fZoom;
	modifiers()->fTransparency = theModifiers.fTransparency;
	modifiers()->fScaleX       = theModifiers.fScaleX;
	modifiers()->fScaleY       = theModifiers.fScaleY;
	modifiers()->fShearX       = theModifiers.fShearX;
	modifiers()->fShearY       = theModifiers.fShearY;
}

QPoint   &MenuObject::currentMousePos()
{
	return m_currentMousePos;
}

QRect   &MenuObject::rect()
{
	return m_rect;
}

QRect   &MenuObject::boundingRect()
{
	return m_boundingRect;
}

void MenuObject::setRect(QRect &rect)
{
	m_rect = rect;
	// The bounding rect is set by drawContents.
	m_boundingRect = rect;
}

void MenuObject::setCurrentMousePos(QPoint &pos)
{
	m_currentMousePos = pos;
}

void MenuObject::setParent(QWidget *pParent)
{
	m_pParent = pParent;
}

QWidget *MenuObject::parent()
{
	return m_pParent;
}

bool    MenuObject::drawRect()
{
	return m_bDrawRect;
}

MenuObject *MenuObject::clone()
{
	return NULL;
}

void MenuObject::setName (QString &qsName)
{
	m_qsName = qsName;
}

void MenuObject::setExtractionPath (QString &qsPath)
{
	m_qsExtractionPath = qsPath;
}

void MenuObject::setAnimation (QString &qsAnimation)
{
	m_qsAnimation = qsAnimation;
}

void MenuObject::slotDelete ()
{
	emit (signalDeleteMe(this));
}

void MenuObject::slotToFront ()
{
	// Send it all the way to the front
	emit (signalMoveOnStack (this, 1000));
	if (m_pContextMenu)
		delete m_pContextMenu;
	m_pContextMenu = NULL;
}

void MenuObject::slotToBack ()
{
	// Send it all the way to the back
	emit (signalMoveOnStack (this, -1000));
	if (m_pContextMenu)
		delete m_pContextMenu;
	m_pContextMenu = NULL;
}

void MenuObject::loadAnimationData (QString &qsFileName, long iMaxNumberOfFrames)
{
	// Called from MenuPreview::createAnimationData
	// Loads in the pure data from a file.
	// Note: changes are done on a per frame basis
	// If no value for a prop at a frame is defined, 
	// then the last value is the winner.
	///////////////////////////////////////////////
	
	// Note, these values will change the true props 
	// of the object.
	// Once rendering is done the original values are re-set.
	QFile file (qsFileName);
	file.open ( IO_ReadOnly );
	QTextStream stream( &file );
	QString line;
	uint t;
	long iFrameNumber;
	int  iPos, iPos2;
	bool bFound;
	QString qsProperty, qsValue;

	for (t=0;t<m_listAnimationAttributes.count();t++)	{
		delete m_listAnimationAttributes[t];
	}
	m_listAnimationAttributes.clear();
	AnimationAttribute *pAnimAttr;

	while ( !stream.atEnd() ) {
		line = stream.readLine(); // line of text excluding '\n'
		iPos = line.find ("::");
		iPos2 = line.find ("=");
		if ( (iPos == -1) || (iPos2 == -1) )
			continue;
		qsProperty  = QString ("");
		qsValue     = QString ("");
		bFound      = false;
		iFrameNumber = line.left (iPos).toInt();
		// Note: Frame position 0 is used to store the original values.
		if ( (iFrameNumber < 1) || (iFrameNumber > iMaxNumberOfFrames) )
			continue;
		qsProperty = line.mid (iPos+2, iPos2-iPos-2);
		
		qsValue = line.right (line.length() - iPos2-1);
		if (qsValue == "SolidLine")
			qsValue = QString ("%1").arg(Qt::SolidLine);
		else if (qsValue == "DashLine")
			qsValue = QString ("%1").arg(Qt::DashLine);
		else if (qsValue == "DashDotLine")
			qsValue = QString ("%1").arg(Qt::DashDotLine);
		else if (qsValue == "DashDotDotLine")
			qsValue = QString ("%1").arg(Qt::DashDotDotLine);
		else if (qsValue == "MiterJoin")
			qsValue = QString ("%1").arg(Qt::MiterJoin);
		else if (qsValue == "BevelJoin")
			qsValue = QString ("%1").arg(Qt::BevelJoin);
		else if (qsValue == "RoundJoin")
			qsValue = QString ("%1").arg(Qt::RoundJoin);
//		printf ("load <%d> <%s>=<%s>\n", iFrameNumber, (const char *)qsProperty, (const char *)qsValue);

		// This loop will check if this property is already taken care of and we have a array of values waiting.
		for (t=0;t<m_listAnimationAttributes.count ();t++)	{
			pAnimAttr = m_listAnimationAttributes[t];
			if (pAnimAttr->name() == qsProperty)	{
				pAnimAttr->append (iFrameNumber, qsValue);
				bFound = true;
				break;
			}
		}
		if ( ! bFound )	{
			pAnimAttr = NULL;
			// If not a standard property, then branch in the object and get the specific attribute 
			// (I.e. text for TextObject etc. )
			pAnimAttr = getSpecificAttributes (iMaxNumberOfFrames, qsProperty);
			if ( ! pAnimAttr )	{
				if (qsProperty == QString("rect.x1"))	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setX);
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.x(), callMeBack);
				}
				else if (qsProperty == QString("rect.x2"))	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setRight);
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.right(), callMeBack);
				}
				else if (qsProperty == "rect.y1")	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setY);
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.y(), callMeBack);
				}
				else if (qsProperty == "rect.y2")	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setBottom);
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.bottom(), callMeBack);
				}
				else if (qsProperty == "rect.width")	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setWidth);
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.width(), callMeBack);
				}
				else if (qsProperty == "rect.height")	{
					FunctionCallback<QRect> *callMeBack = new FunctionCallback<QRect>(m_rect, &QRect::setHeight);
 					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_rect.height(), callMeBack);
				}
				else if (qsProperty == "zoom")
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fZoom, &m_modifiers.fZoom);
				else if (qsProperty == "rotate")
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fRotate, &m_modifiers.fRotate);
				else if (qsProperty == "shear.x")
 					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fShearX, &m_modifiers.fShearX);
				else if (qsProperty == "shear.y")
 					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fShearY, &m_modifiers.fShearY);
				else if (qsProperty == "scale.x")
 					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fScaleX, &m_modifiers.fScaleX);
				else if (qsProperty == "scale.y")
 					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fScaleY, &m_modifiers.fScaleY);
				else if (qsProperty == "transparency")
					pAnimAttr = new AnimationAttribute (iMaxNumberOfFrames, qsProperty, m_modifiers.fTransparency, &m_modifiers.fTransparency);
			}
			if (pAnimAttr)
				m_listAnimationAttributes.append ( pAnimAttr );
		}
		if (pAnimAttr)
			pAnimAttr->append (iFrameNumber, qsValue);
	}
	file.close();
}

/*
	if (listAnimationAttributes.count() < 1)
		return;
	// This part in the MenuPreview or ButtonPreview - class
	iMaxNumberOfFrames = listAnimationAttributes[0]->maxFrames();
	for (i=0;i<iMaxNumberOfFrames;i++)	{
		for (t=0;t<listAnimationAttributes.count();t++)	{
			listAnimationAttributes[t]->setValue (i);
printf ("<%d : %ld>X1=<%d> Y1=<%d> trans=<%03f>\n", t, i, m_rect.x(), m_rect.y(), m_modifiers.fTransparency);
		}
	}
}


	QRect	    m_rect;
	QRect       m_boundingRect;
	QWidget    *m_pParent;
	bool        m_bDrawRect;
	Modifiers   m_modifiers;
	QString     m_qsAnimation;	// script or dataset holds also the datafilename
	QPoint      m_currentMousePos;
*/

