#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tormentum: Dark Sorrow
# send your bug reports to contact@dotslashplay.it
###

script_version=20240627.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='tormentum-dark-sorrow'
GAME_NAME='Tormentum: Dark Sorrow'

ARCHIVE_BASE_0_NAME='setup_tormentum_-_dark_sorrow_1.4.1_(15803).exe'
ARCHIVE_BASE_0_MD5='7fdeef4f8a6c82c75e85576497684460'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.4.1-gog15803'
ARCHIVE_BASE_0_SIZE='340000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/tormentum_dark_sorrow'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
adobe air
tormentum.exe'
CONTENT_GAME_DATA_FILES='
assets
ico
meta-inf
mimetype
tormentum.swf'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/com.ohnoo.Tormentum'

APP_MAIN_EXE='tormentum.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
