//*****************************************************************************
//
// File:    Test03.java
// Package: edu.rit.phyl.pars.test
// Unit:    Class edu.rit.phyl.pars.test.Test03
//
// This Java source file is copyright (C) 2007 by Alan Kaminsky. All rights
// reserved. For further information, contact the author, Alan Kaminsky, at
// ark@cs.rit.edu.
//
// This Java source file is part of the Parallel Java Library ("PJ"). PJ is free
// software; you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
//
// PJ is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
// A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
// A copy of the GNU General Public License is provided in the file gpl.txt. You
// may also obtain a copy of the GNU General Public License on the World Wide
// Web at http://www.gnu.org/licenses/gpl.html.
//
//******************************************************************************

package edu.rit.phyl.pars.test;

import edu.rit.phyl.pars.DnaSequence;
import edu.rit.phyl.pars.DnaSequenceTree;

/**
 * Class Test03 is a unit test program for class {@linkplain
 * edu.rit.phyl.pars.DnaSequenceTree}. It generates all possible rooted
 * bifurcated trees with a given number of tip nodes and prints each tree on the
 * standard output in Newick Standard format.
 * <P>
 * Usage: java edu.rit.phyl.pars.test.Test03 <I>N</I>
 * <BR><I>N</I> = Number of tip nodes
 *
 * @author  Alan Kaminsky
 * @version 23-Apr-2007
 */
public class Test03
	{

// Prevent construction.

	private Test03()
		{
		}

// Global variables.

	static int N;
	static DnaSequenceTree[] treestack;

	static final DnaSequenceTree.Stringifier stringifier =
		new DnaSequenceTree.Stringifier()
			{
			public String toString
				(DnaSequenceTree.Node node)
				{
				StringBuilder buf = new StringBuilder();
				int v = node.sequence().score()+1;
				while (v > 0)
					{
					buf.insert (0, v2c[v%27]);
					v /= 27;
					}
				return buf.toString();
				}
			};
	static final char[] v2c = new char[]
		{' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
		 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q',
		 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

// Main program.

	/**
	 * Unit test main program.
	 */
	public static void main
		(String[] args)
		throws Exception
		{
		if (args.length != 1) usage();
		N = Integer.parseInt (args[0]);
		treestack = new DnaSequenceTree [N];
		for (int i = 0; i < N; ++ i)
			{
			treestack[i] = new DnaSequenceTree (N);
			}
		DnaSequenceTree.defaultStringifier (stringifier);
		treestack[0].addTipNode (0, new DnaSequence (0, 0));
		generateTrees (0);
		}

// Hidden operations.

	/**
	 * Generate all trees with one more tip node than the tree at the given
	 * stack level.
	 *
	 * @param  level  Stack level.
	 */
	private static void generateTrees
		(int level)
		{
		DnaSequenceTree tree = treestack[level];
		if (tree.isFull())
			{
			System.out.println (tree);
			}
		else
			{
			DnaSequenceTree nexttree = treestack[level+1];
			int count = tree.nodeCount();
			for (int i = 0; i < count; ++ i)
				{
				nexttree.copy (tree);
				nexttree.addTipNode (i, new DnaSequence (0, level+1));
				generateTrees (level+1);
				}
			}
		}

	/**
	 * Print a usage message and exit.
	 */
	private static void usage()
		{
		System.err.println ("Usage: java edu.rit.phyl.pars.test.Test03 <N>");
		System.err.println ("<N> = Number of tip nodes");
		System.exit (1);
		}

	}
