//******************************************************************************
//
// File:    Program1Seq.java
// Package: ---
// Unit:    Class Program1Seq
//
// This Java source file is copyright (C) 2006 by Alan Kaminsky. All rights
// reserved. For further information, contact the author, Alan Kaminsky, at
// ark@cs.rit.edu.
//
// This Java source file is part of the Parallel Java Library ("PJ"). PJ is free
// software; you can redistribute it and/or modify it under the terms of the GNU
// General Public License as published by the Free Software Foundation; either
// version 3 of the License, or (at your option) any later version.
//
// PJ is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
// A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
// A copy of the GNU General Public License is provided in the file gpl.txt. You
// may also obtain a copy of the GNU General Public License on the World Wide
// Web at http://www.gnu.org/licenses/gpl.html.
//
//******************************************************************************

import edu.rit.pj.Comm;

/**
 * Class Program1Seq is the sequential version of the first program illustrating
 * parallel computing.
 * <P>
 * Usage: java Program1Seq
 *
 * @author  Alan Kaminsky
 * @version 03-Apr-2006
 */
public class Program1Seq
	{

// Prevent construction.

	private Program1Seq()
		{
		}

// Global variables.

	static long t1, t2[], t3[];

// Exported operations.

	/**
	 * Main program.
	 */
	public static void main
		(String[] args)
		throws Exception
		{
		Comm.init (args);
		t1 = System.currentTimeMillis();
		t2 = new long [5];
		t3 = new long [5];
		for (int x = 1; x <= 4; ++ x)
			{
			t2[x] = System.currentTimeMillis();
			multiply (x);
			t3[x] = System.currentTimeMillis();
			}
		for (int x = 1; x <= 4; ++ x)
			{
			System.out.println
				("x = "+x+" call start = "+(t2[x]-t1)+" msec");
			System.out.println
				("x = "+x+" call finish = "+(t3[x]-t1)+" msec");
			}
		}

// Hidden operations.

	/**
	 * Subroutine for one computation. Multiplies its argument by 500 million.
	 */
	private static int multiply
		(int x)
		{
		int y = 0;
		for (int i = 1; i <= 500000000; ++ i) y += x;
		return y;
		}

	}
