/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef consoleH
#define consoleH

#include "GroupFile.h"
#include "art.h"

extern void CreateConsole(GroupFile *group,int scrnX,int scrnY,Art *art);
extern void ResizeConsole(int scrnX,int scrnY);
extern void ConsoleGameReady();
extern void ToggleConsole();
extern void ToggleConsoleImmediate();
extern void ConsoleOutput(char *text);
#ifdef PLATFORM_UNIX
extern int ConsoleTypeChar(WORD key);
#else
extern int ConsoleTypeChar(char key);
#endif
extern void cprintf(char *str,...);
extern int IsCommandReady();
extern char* CommandString();
extern void RenderConsole();
extern void UpdateConsolePos();
extern void ForceConsoleRedraw();
extern void CheckNonGraphicalConsoleInput(HWND hWnd);
extern int IsConsoleDown();
//---------------------------------------------------------------------------
#endif
