/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMCONFORMSTOPROFILEACCESS_H_

#include "Base_Server_Common.h"

#include "OpenDRIM_ComputerSystemConformsToProfile.h"
#include "assocOpenDRIM_ComputerSystemConformsToProfile.h"

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_unload(string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemConformsToProfile& instance, const char** properties, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& newInstance, const OpenDRIM_ComputerSystemConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_ComputerSystemConformsToProfile>& OpenDRIM_ComputerSystemConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_ComputerSystemConformsToProfile>& OpenDRIM_ComputerSystemConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int Base_Server_OpenDRIM_ComputerSystemConformsToProfile_populate(OpenDRIM_ComputerSystemConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMCONFORMSTOPROFILEACCESS_H_*/
