// File:        TDataStd_IntegerArray.cxx
// Created:     Wed Jun  16 10:32:25 1999
// Author:      Sergey RUIN


#include <TDataStd_IntegerArray.ixx>

#define OCC925
#define OCC2932

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_IntegerArray::GetID() 
{ 
  static Standard_GUID TDataStd_IntegerArrayID ("2a96b61d-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_IntegerArrayID; 
}


//=======================================================================
//function : TDataStd_IntegerArray
//purpose  : Empty Constructor
//=======================================================================

TDataStd_IntegerArray::TDataStd_IntegerArray() {}

//=======================================================================
//function : Init
//purpose  : 
//=======================================================================

void TDataStd_IntegerArray::Init(const Standard_Integer lower,
                                 const Standard_Integer upper)
{
#ifdef OCC925
  Backup();
#endif
  myValue = new TColStd_HArray1OfInteger(lower, upper, 0);
}

//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_IntegerArray) TDataStd_IntegerArray::Set
                                                (const TDF_Label&       label,
                                                 const Standard_Integer lower,
                                                 const Standard_Integer upper) 

{
  Handle(TDataStd_IntegerArray) A;
  if (!label.FindAttribute (TDataStd_IntegerArray::GetID(), A)) {
    A = new TDataStd_IntegerArray;
    A->Init (lower, upper); 
    label.AddAttribute(A);
  }
  return A;
}


//=======================================================================
//function : SetValue
//purpose  : 
//=======================================================================

void TDataStd_IntegerArray::SetValue(const Standard_Integer index, const Standard_Integer value) 
{
  // OCC2932 correction
  if(myValue.IsNull()) return;
  if( myValue->Value(index) == value)
    return; 

  Backup();
//  if(!myValue.IsNull())
    myValue->SetValue(index, value);
}


//=======================================================================
//function : GetValue
//purpose  : 
//=======================================================================

Standard_Integer TDataStd_IntegerArray::Value (const Standard_Integer index) const 
{
  if(!myValue.IsNull())
    return myValue->Value(index); 
  else
    return 0;
}



//=======================================================================
//function : Lower
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_IntegerArray::Lower (void) const 
{ 
  if(!myValue.IsNull())
    return myValue->Lower(); 
  else
    return 0;
}


//=======================================================================
//function : Upper
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_IntegerArray::Upper (void) const 
{ 
  if(!myValue.IsNull())
    return myValue->Upper(); 
  else
    return 0;
}


//=======================================================================
//function : Length
//purpose  : 
//=======================================================================
Standard_Integer TDataStd_IntegerArray::Length (void) const 
{
  if(!myValue.IsNull())
    return myValue->Length(); 
  else
    return 0;
}


//=======================================================================
//function : ChangeArray
//purpose  : If value of <newArray> differs from <myValue>, Backup 
//         : performed and myValue refers to new instance of HArray1OfInteger 
//         : that holds <newArray>
//=======================================================================

void TDataStd_IntegerArray::ChangeArray(const Handle(TColStd_HArray1OfInteger)& newArray) 
{
  Standard_Integer aLower    = newArray->Lower();
  Standard_Integer anUpper   = newArray->Upper();
  Standard_Boolean aDimEqual = Standard_False;
  Standard_Integer i;
#ifdef OCC2932
  if (Lower() == aLower && Upper() == anUpper)
  {
    aDimEqual = Standard_True;
    Standard_Boolean isEqual = Standard_True;
    for(i = aLower; i <= anUpper; i++) {
      if(myValue->Value(i) != newArray->Value(i)) {
        isEqual = Standard_False;
        break;
      }
    }
    if(isEqual)
      return;
  }
#endif

  Backup();
// Handles of myValue of current and backuped attributes will be different!
  if(!aDimEqual) 
    myValue = new TColStd_HArray1OfInteger(aLower, anUpper);
  
  for(i = aLower; i <= anUpper; i++) 
    myValue->SetValue(i, newArray->Value(i));
}

//=======================================================================
//function : Array
//purpose  : 
//=======================================================================

Handle(TColStd_HArray1OfInteger) TDataStd_IntegerArray::Array(void) const
{
  return myValue; 
}


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_IntegerArray::ID () const { return GetID(); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_IntegerArray::NewEmpty () const
{  
  return new TDataStd_IntegerArray(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_IntegerArray::Restore(const Handle(TDF_Attribute)& With) 
{
  Standard_Integer i, lower, upper;
  Handle(TDataStd_IntegerArray) anArray = Handle(TDataStd_IntegerArray)::DownCast(With);
  if(!anArray->myValue.IsNull()) {
    lower = anArray->Lower();
    upper = anArray->Upper(); 
    myValue = new TColStd_HArray1OfInteger(lower, upper);
    for(i = lower; i<=upper; i++)
      myValue->SetValue(i, anArray->Value(i)); 
  }
  else
    myValue.Nullify();
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_IntegerArray::Paste (const Handle(TDF_Attribute)& Into,
                                   const Handle(TDF_RelocationTable)& ) const
{

  if(!myValue.IsNull()) {
    Handle(TDataStd_IntegerArray) anArray = Handle(TDataStd_IntegerArray)::DownCast(Into);
    if(!anArray.IsNull())
      anArray->ChangeArray( myValue );
  }
}

//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_IntegerArray::Dump (Standard_OStream& anOS) const
{  
  anOS << "IntegerArray";
  return anOS;
}

