// File:	StepToGeom_MakeCurve2d.cxx
// Created:	Wed Aug  4 10:45:01 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:n7 abv 15.02.99: S4132: adding translation of curve_replica
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeCurve2d.ixx>
#include <StdFail_NotDone.hxx>
#include <StepGeom_Curve.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepGeom_HArray1OfTrimmingSelect.hxx>
#include <StepToGeom_MakeLine2d.hxx>
#include <StepToGeom_MakeConic2d.hxx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Conic.hxx>
#include <StepGeom_BoundedCurve.hxx>
#include <StepToGeom_MakeBoundedCurve2d.hxx>
#include <Geom2d_TrimmedCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Geom2dConvert.hxx>
#include <StepGeom_CurveReplica.hxx>
#include <StepGeom_CartesianTransformationOperator2d.hxx>
#include <StepToGeom_MakeTransformation2d.hxx>

//=============================================================================
// Creation d' une Curve de Geom2d a partir d' une Curve de Step
//=============================================================================

StepToGeom_MakeCurve2d::StepToGeom_MakeCurve2d( const Handle(StepGeom_Curve)& C)
{
  done = Standard_False;

  // UPDATE 21-04-95 by FMA

  if (C->IsKind(STANDARD_TYPE(StepGeom_Line))) {
    Handle(StepGeom_Line) L = Handle(StepGeom_Line)::DownCast(C);
    StepToGeom_MakeLine2d MkLine2d(L);
    if ( MkLine2d.IsDone() ) theCurve = MkLine2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Conic))) {
    Handle(StepGeom_Conic) L = Handle(StepGeom_Conic)::DownCast(C);
    StepToGeom_MakeConic2d MkConic2d(L);
    if ( MkConic2d.IsDone() ) theCurve = MkConic2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_BoundedCurve))) {
    Handle(StepGeom_BoundedCurve) L = Handle(StepGeom_BoundedCurve)::DownCast(C);
    StepToGeom_MakeBoundedCurve2d MkBoundedC2d(L);
    if ( MkBoundedC2d.IsDone() ) theCurve = MkBoundedC2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_CurveReplica))) { //:n7 abv 16 Feb 99
    Handle(StepGeom_CurveReplica) CR = Handle(StepGeom_CurveReplica)::DownCast(C);
    Handle(StepGeom_Curve) PC = CR->ParentCurve();
    Handle(StepGeom_CartesianTransformationOperator2d) T = 
      Handle(StepGeom_CartesianTransformationOperator2d)::DownCast(CR->Transformation());
    // protect against cyclic references and wrong type of cartop
    if ( ! T.IsNull() && PC != C ) {
      StepToGeom_MakeCurve2d MkCurve(PC);
      if ( MkCurve.IsDone() ) {
	theCurve = MkCurve.Value();
	StepToGeom_MakeTransformation2d MkT ( T );
	theCurve->Transform ( MkT.Value() );
      }
    }
  }
  done = ! theCurve.IsNull();
}	 

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Curve) &
      StepToGeom_MakeCurve2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCurve;
}
