// File:	StepToGeom_MakeCartesianPoint.cxx
// Created:	Fri Jul  2 16:09:46 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeCartesianPoint.ixx>
#include <StepGeom_CartesianPoint.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un CartesianPoint de Geom a partir d' un CartesianPoint de Step
//=============================================================================

StepToGeom_MakeCartesianPoint::StepToGeom_MakeCartesianPoint
  ( const Handle(StepGeom_CartesianPoint)& P)
{
  if (P->NbCoordinates() != 3 ) done = Standard_False;
  else
    {
      Standard_Real X = P->CoordinatesValue(1) * UnitsMethods::LengthFactor();
      Standard_Real Y = P->CoordinatesValue(2) * UnitsMethods::LengthFactor();
      Standard_Real Z = P->CoordinatesValue(3) * UnitsMethods::LengthFactor();
      theCartesianPoint = new Geom_CartesianPoint(X, Y, Z);
      done = Standard_True;
    }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_CartesianPoint) &
      StepToGeom_MakeCartesianPoint::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCartesianPoint;
}
