
#define OCC2934         /* SAN 22/01/04 Texture mapped fonts on WNT */

#if defined(OCC2934) && defined(WNT)
#include <OpenGl_tgl_all.h>

#include <stddef.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGl_cmn_varargs.h>
#include <OpenGl_cmn_memory.h>
#include <OpenGl_telem_attri.h>
#include <OpenGl_tsm.h>
#include <OpenGl_telem.h>
#include <OpenGl_telem_inquire.h>

static  TStatus  TextureMappedFontDisplay( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextureMappedFontAdd( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextureMappedFontPrint( TSM_ELEM_DATA, Tint, cmn_key* );

static  TStatus  (*MtdTbl[])( TSM_ELEM_DATA, Tint, cmn_key* ) =
{
    0,             /* PickTraverse */
    TextureMappedFontDisplay,
    TextureMappedFontAdd,
    0,             /* Delete */
    TextureMappedFontPrint,
    0              /* Inquire */
};


MtblPtr
TelTextureMappedFontInitClass( TelType *el )
{
   *el = TelTextureMappedFont;
   return MtdTbl;
}

static  TStatus
TextureMappedFontAdd( TSM_ELEM_DATA d, Tint n, cmn_key *k )
{
    ((tsm_elem_data)(d.pdata))->ldata = k[0]->data.ldata;

    return TSuccess;
}


static  TStatus
TextureMappedFontDisplay( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    CMN_KEY  key;

    key.id = TelTextureMappedFont;
    key.data.ldata = data.ldata;
    TsmSetAttri( 1, &key );
    return TSuccess;
}


static  TStatus
TextureMappedFontPrint( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    fprintf( stdout, "TelTextureMappedFont. Value = %d\n", data.ldata);
    fprintf( stdout, "\n" );

    return TSuccess;
}

#endif  /* #if defined(OCC2934) && defined(WNT) */
