/* MPOSUI.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmposui_(dimmat, nistoc, aposit, posuiv, iercod)
integer *dimmat, *nistoc, *aposit, *posuiv, *iercod;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static logical ldbg;
    static integer imin, jmin, i__, j, k;
    static logical trouve;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       REMPLISSAGE DE LA TABLE DE POSITIONNEMENT POSUIV QUI PERMET DE */
/*       PARCOURIR EN COLONNE LA PARTIE TRAINGULAIRE INFERIEUR DE LA */
/*       MATRICE  SOUS FORME DE PROFIL */


/*     MOTS CLES : */
/*     ----------- */
/*      RESERVE, MATRICE, PROFIL */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */

/*       NISTOC: NOMBRE DE COEFFICIENTS DANS LE PROFILE */
/*       DIMMAT: NOMBRE DE LIGNE DE LA MATRICE CARRE SYMETRIQUE */
/*       APOSIT: TABLE DE POSITIONNEMENT DES TERMES DE STOCKAGE */
/*               APOSIT(1,I) CONTIENT LE NOMBRE DE TERMES-1 SUR LA LIGNE 
*/
/*               I DANS LE PROFIL DE LA MATRICE */
/*              APOSIT(2,I) CONTIENT L'INDICE DE STOCKAGE DU TERME DIAGONA
L*/
/*               DE LA LIGNE I */


/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*       POSUIV: POSUIV(K) (OU K EST L'INDICE DE STOCKAGE DE MAT(I,J)) */
/*               CONTIENT LE PLUS PETIT NUMERO IMIN>I DE LA  LIGNE QUI */
/*               POSSEDE UN TERME MAT(IMIN,J) QUI EST DANS LE PROFIL. */
/*               S'IL N'Y A PAS LE TERME MAT(IMIN,J) DANS LE PROFIL */
/*               ALORS POSUIV(K)=-1 */




/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     23-08-95 : KHN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */



/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    aposit -= 3;
    --posuiv;

    /* Function Body */
    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMPOSUI", 7L);
    }
    *iercod = 0;


/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */



    i__1 = *dimmat;
    for (i__ = 1; i__ <= i__1; ++i__) {
	jmin = i__ - aposit[(i__ << 1) + 1];
	i__2 = i__;
	for (j = jmin; j <= i__2; ++j) {
	    imin = i__ + 1;
	    trouve = FALSE_;
	    while(! trouve && imin <= *dimmat) {
		if (imin - aposit[(imin << 1) + 1] <= j) {
		    trouve = TRUE_;
		} else {
		    ++imin;
		}
	    }
	    k = aposit[(i__ << 1) + 2] - i__ + j;
	    if (trouve) {
		posuiv[k] = imin;
	    } else {
		posuiv[k] = -1;
	    }
	}
    }





    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */




/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:

/* ___ DESALLOCATION, ... */

    maermsg_("MMPOSUI", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMPOSUI", 7L);
    }
 return 0 ;
} /* mmposui_ */

