/* MINLTT.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mminltt_(ncolmx, nlgnmx, tabtri, nbrcol, nbrlgn, ajoute, 
	epseg, iercod)
integer *ncolmx, *nlgnmx;
doublereal *tabtri;
integer *nbrcol, *nbrlgn;
doublereal *ajoute, *epseg;
integer *iercod;
{
    /* System generated locals */
    integer tabtri_dim1, tabtri_offset, i__1, i__2;

    /* Local variables */
    static logical idbg;
    static integer icol, ilgn, nlgn, noct, inser;
    static doublereal epsega;
    static integer ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mcrfill_(), maermsg_(), mgenmsg_(), mgsomsg_()
	    ;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        . Insertion d'une ligne dans une table triee sans redondance */

/*     MOTS CLES : */
/*     ----------- */
/*      TOUS,MATH_ACCES :: TABLEAU&,INSERTION,&TABLEAU */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*        . NCOLMX : Nombre de colonnes du tableau */
/*        . NLGNMX : Nombre de lignes du tableau */
/*        . TABTRI : Tableau trie par lignes sans redondances */
/*        . NBRCOL : Nombre de colonnes utilisees */
/*        . NBRLGN : Nombre de lignes utilisees */
/*        . AJOUTE : Ligne a ajouter */
/*        . EPSEGA : Epsilon pour le test de redondance */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*        . TABTRI : Tableau trie par lignes sans redondances */
/*        . NBRLGN : Nombre de lignes utilisees */
/*        . IERCOD : 0 -> Pas de probleme */
/*                   1 -> La table est pleine */

/*     COMMONS UTILISES : */
/*     ------------------ */

/*     REFERENCES APPELEES : */
/*     --------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*        . On n'insere la ligne que si il n'y a pas de ligne tq tous ses 
*/
/*     elements soient egaux a ceux qu'on veut inserer a epsilon pres. */

/*        . Niveau de debug = 3 */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*        . 24-06-91 : RBD; Suppression des accents (Pb. Bull). */
/*        . 01-10-89 : VV ; Version originale */
/* > */
/* ***********************************************************************
 */
/*     DECLARATIONS , CONTROLE DES ARGUMENTS D'ENTREE , INITIALISATION */
/* ***********************************************************************
 */

/* --- Parametres */


/* --- Fonctions */


/* --- Variables locales */


/* --- Messagerie */

    /* Parameter adjustments */
    tabtri_dim1 = *ncolmx;
    tabtri_offset = tabtri_dim1 + 1;
    tabtri -= tabtri_offset;
    --ajoute;

    /* Function Body */
    ibb = mnfndeb_();
    idbg = ibb >= 3;
    if (idbg) {
	mgenmsg_("MMINLTT", 7L);
    }

/* --- Controle arguments */

    if (*nbrlgn >= *nlgnmx) {
	goto L9001;
    }

/* -------------------- */
/* *** INITIALISATIONS */
/* -------------------- */

    *iercod = 0;

/* ---------------------------- */
/* *** RECHERCHE DE REDONDANCE */
/* ---------------------------- */

    i__1 = *nbrlgn;
    for (ilgn = 1; ilgn <= i__1; ++ilgn) {
	if (tabtri[ilgn * tabtri_dim1 + 1] >= ajoute[1] - epsega) {
	    if (tabtri[ilgn * tabtri_dim1 + 1] <= ajoute[1] + epsega) {
		i__2 = *nbrcol;
		for (icol = 1; icol <= i__2; ++icol) {
		    if (tabtri[icol + ilgn * tabtri_dim1] < ajoute[icol] - 
			    epsega || tabtri[icol + ilgn * tabtri_dim1] > 
			    ajoute[icol] + epsega) {
			goto L20;
		    }
/* L10: */
		}
		goto L9999;
	    } else {
		goto L30;
	    }
	}
L20:
	;
    }

/* ----------------------------------- */
/* *** RECHERCHE DU POINT D'INSERTION */
/* ----------------------------------- */

L30:

    i__1 = *nbrlgn;
    for (ilgn = 1; ilgn <= i__1; ++ilgn) {
	i__2 = *nbrcol;
	for (icol = 1; icol <= i__2; ++icol) {
	    if (tabtri[icol + ilgn * tabtri_dim1] < ajoute[icol]) {
		goto L50;
	    }
	    if (tabtri[icol + ilgn * tabtri_dim1] > ajoute[icol]) {
		goto L70;
	    }
/* L60: */
	}
L50:
	;
    }

    ilgn = *nbrlgn + 1;

/* -------------- */
/* *** INSERTION */
/* -------------- */

L70:

    inser = ilgn;
    ++(*nbrlgn);

/* --- Decalage vers le bas */

    nlgn = *nbrlgn - inser;
    if (nlgn > 0) {
	noct = (*ncolmx << 3) * nlgn;
	mcrfill_(&noct, &tabtri[inser * tabtri_dim1 + 1], &tabtri[(inser + 1) 
		* tabtri_dim1 + 1]);
    }

/* --- Copie de la ligne */

    noct = *nbrcol << 3;
    mcrfill_(&noct, &ajoute[1], &tabtri[inser * tabtri_dim1 + 1]);

    goto L9999;

/* ******************************************************************** */
/*       SORTIE ERREUR , RETOUR PROGRAMME APPELANT , MESSAGERIE */
/* ******************************************************************** */

/* --- La table est deja pleine */

L9001:
    *iercod = 1;

/* --- Fin */

L9999:
    if (*iercod != 0) {
	maermsg_("MMINLTT", iercod, 7L);
    }
    if (idbg) {
	mgsomsg_("MMINLTT", 7L);
    }
 return 0 ;
} /* mminltt_ */

