/* MA2ROO.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <ApproxF2var.h>
#endif 
/* Subroutine */ int mma2roo_(nbpntu, nbpntv, urootl, vrootl)
const integer *nbpntu, *nbpntv;
doublereal *urootl, *vrootl;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer ii, ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_(), mmrtptt_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Recuperation des racines de Legendre pour les discretisations. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS, AB_SPECIFI::CONTRAINTE&, DISCRETISATION, &POINT */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     NBPNTU: Nbre de parametres INTERNES de discretisation EN U. */
/*             C'est aussi le nbre de racine du polynome de Legendre ou */
/*             on discretise. */
/*     NBPNTV: Nbre de parametres INTERNES de discretisation EN V. */
/*             C'est aussi le nbre de racine du polynome de Legendre ou */
/*             on discretise. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     UROOTL: Tableau des parametres de discretisation SUR (-1,1) EN U. 
*/
/*     VROOTL: Tableau des parametres de discretisation SUR (-1,1) EN V. 
*/

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     02-07-1991: RBD; Creation. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */


    /* Parameter adjustments */
    --urootl;
    --vrootl;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMA2ROO", 7L);
    }

/* ---------------- Recup des racines POSITIVES sur U ------------------ 
*/

    mmrtptt_(nbpntu, &urootl[(*nbpntu + 1) / 2 + 1]);
    i__1 = *nbpntu / 2;
    for (ii = 1; ii <= i__1; ++ii) {
	urootl[ii] = -urootl[*nbpntu - ii + 1];
/* L100: */
    }
    if (*nbpntu % 2 == 1) {
	urootl[*nbpntu / 2 + 1] = 0.;
    }

/* ---------------- Recup des racines POSITIVES sur V ------------------ 
*/

    mmrtptt_(nbpntv, &vrootl[(*nbpntv + 1) / 2 + 1]);
    i__1 = *nbpntv / 2;
    for (ii = 1; ii <= i__1; ++ii) {
	vrootl[ii] = -vrootl[*nbpntv - ii + 1];
/* L110: */
    }
    if (*nbpntv % 2 == 1) {
	vrootl[*nbpntv / 2 + 1] = 0.;
    }

/* ------------------------------ The End ------------------------------- 
*/

    if (ibb >= 3) {
	mgsomsg_("MMA2ROO", 7L);
    }
    return 0;
} /* mma2roo_ */

