/* MA2MOY.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mma2moy_(ndgumx, ndgvmx, ndimen, mindgu, maxdgu, mindgv, 
	maxdgv, iordru, iordrv, patjac, errmoy)
integer *ndgumx, *ndgvmx, *ndimen, *mindgu, *maxdgu, *mindgv, *maxdgv, *
	iordru, *iordrv;
doublereal *patjac, *errmoy;
{
    /* System generated locals */
    integer patjac_dim1, patjac_dim2, patjac_offset, i__1, i__2, i__3;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static logical ldbg;
    static integer minu, minv, idebu, idebv, ii, nd, jj;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_();
    static doublereal bid0, bid1;
    extern /* Subroutine */ int mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*  Calcule l'erreur moyenne d'approximation faite lorsque l'on ne */
/*  garde que les coefficients de PATJAC de degre compris entre */
/*  2*(IORDRU+1) et MINDGU en U et 2*(IORDRV+1) et MINDGV en V. */

/*     MOTS CLES : */
/*     ----------- */
/*        LEGENDRE,APPROXIMATION,ERREUR MOYENNE */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     NDGUMX: Dimension en U du tableau PATJAC. */
/*     NDGVMX: Dimension en V du tableau PATJAC. */
/*     NDIMEN: Dimension de l'espace. */
/*     MINDGU: Borne inf de l'indice en U des coeff. de PATJAC a prendre 
*/
/*             en compte. */
/*     MAXDGU: Borne sup de l'indice en U des coeff. de PATJAC a prendre 
*/
/*             en compte. */
/*     MINDGV: Borne inf de l'indice en V des coeff. de PATJAC a prendre 
*/
/*             en compte. */
/*     MAXDGV: Borne sup de l'indice en V des coeff. de PATJAC a prendre 
*/
/*             en compte. */
/*     IORDRU: Ordre de continuite en U assure par le carreau PATJAC */
/*             (de -1 a 2) */
/*     IORDRV: Ordre de continuite en V assure par le carreau PATJAC */
/*             (de -1 a 2) */
/*     PATJAC: Table des coeff. du carreau d'approximation avec */
/*             contraintes d'ordre IORDRU en U et IORDRV en V. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     ERRMOY: L'erreur moyenne commise en ne gardant que les coeff de */
/*             PATJAC 2*(IORDRU+1) a MINDGU en U et 2*(IORDRV+1) a */
/*             MINDGV en V. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Dans le tableau PATJAC sont stockes les coeff. Cij du carreau */
/*     d'approximation de F(U,V). Les indices i et j indique le degre en 
*/
/*     U et en V des polynomes de base. Ces polynomes de base sont de la 
*/
/*     forme: */

/*          ((1 - U*U)**(IORDRU+1)).J(i-2*(IORDRU+1)(U), ou */

/*     le polynome J(i-2*(IORDU+1)(U) est le polynome de Jacobi d'ordre */
/*     IORDRU+1 (idem en V en remplacant U par V dans l'expression ci */
/*     dessus). */

/*     La contribution a l'erreur moyenne du terme Cij lorsque */
/*     celui-ci est enleve de PATJAC est Cij*Cij. */


/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     13-06-1991: RBD; Creation. */
/* > */
/* ***********************************************************************
 */
/*   Le nom de la routine */


/* ----------------------------- Initialisations ------------------------ 
*/

    /* Parameter adjustments */
    patjac_dim1 = *ndgumx + 1;
    patjac_dim2 = *ndgvmx + 1;
    patjac_offset = patjac_dim1 * patjac_dim2;
    patjac -= patjac_offset;

    /* Function Body */
    ldbg = mnfndeb_() >= 3;
    if (ldbg) {
	mgenmsg_("MMA2MOY", 7L);
    }

    idebu = (*iordru + 1) << 1;
    idebv = (*iordrv + 1) << 1;
    minu = max(idebu,*mindgu);
    minv = max(idebv,*mindgv);
    bid0 = 0.;
    *errmoy = 0.;

/* ------------------ Calcul du majorant de l'erreur moyenne ------------ 
*/
/* ----- lorsque sont enleves les coeff. d'indices MINDGU a MAXDGU ------ 
*/
/* ---------------- en U et d'indices MINDGV a MAXDGV en V -------------- 
*/

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = *maxdgv;
	for (jj = minv; jj <= i__2; ++jj) {
	    i__3 = *maxdgu;
	    for (ii = idebu; ii <= i__3; ++ii) {
		bid1 = patjac[ii + (jj + nd * patjac_dim2) * patjac_dim1];
		bid0 += bid1 * bid1;
/* L300: */
	    }
/* L200: */
	}
/* L100: */
    }

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = minv - 1;
	for (jj = idebv; jj <= i__2; ++jj) {
	    i__3 = *maxdgu;
	    for (ii = minu; ii <= i__3; ++ii) {
		bid1 = patjac[ii + (jj + nd * patjac_dim2) * patjac_dim1];
		bid0 += bid1 * bid1;
/* L600: */
	    }
/* L500: */
	}
/* L400: */
    }

/* ----------------------- Calcul de l'erreur moyenne ------------------- 
*/

    bid0 /= 4;
    *errmoy = sqrt(bid0);

/* ------------------------- The end ------------------------------------ 
*/

    if (ldbg) {
	mgsomsg_("MMA2MOY", 7L);
    }
    return 0;
} /* mma2moy_ */

