// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FunctionSet_HeaderFile
#define _math_FunctionSet_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This abstract class describes the virtual functions associated to <br>
//! a set on N Functions of M independant variables. <br>
class math_FunctionSet  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~math_FunctionSet(){Delete();}

//! Returns the number of variables of the function. <br>
Standard_EXPORT virtual  Standard_Integer NbVariables() const = 0;

//! Returns the number of equations of the function. <br>
Standard_EXPORT virtual  Standard_Integer NbEquations() const = 0;

//! Computes the values <F> of the functions for the <br>
//!          variable <X>. <br>
//!          returns True if the computation was done successfully, <br>
//!          False otherwise. <br>
Standard_EXPORT virtual  Standard_Boolean Value(const math_Vector& X,math_Vector& F)  = 0;

//! Returns the state of the function corresponding to the <br>
//!          latestcall of any methods associated with the function. <br>
//!          This function is called by each of the algorithms <br>
//!          described later which define the function Integer <br>
//!          Algorithm::StateNumber(). The algorithm has the <br>
//!          responsibility to call this function when it has found <br>
//!          a solution (i.e. a root or a minimum) and has to maintain <br>
//!          the association between the solution found and this <br>
//!          StateNumber. <br>
//!          Byu default, this method returns 0 (which means for the <br>
//!          algorithm: no state has been saved). It is the <br>
//!          responsibility of the programmer to decide if he needs <br>
//!          to save the current state of the function and to return <br>
//!          an Integer that allows retrieval of the state. <br>
Standard_EXPORT virtual  Standard_Integer GetStateNumber() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
