// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gp_Trsf2d_HeaderFile
#define _gp_Trsf2d_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_TrsfForm_HeaderFile
#include <gp_TrsfForm.hxx>
#endif
#ifndef _gp_Mat2d_HeaderFile
#include <gp_Mat2d.hxx>
#endif
#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class Standard_OutOfRange;
class gp_GTrsf2d;
class gp_Trsf;
class gp_Pnt2d;
class gp_Ax2d;
class gp_Vec2d;
class gp_XY;
class gp_Mat2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& gp_Trsf2d_Type_();


//!  Defines a non-persistent transformation in 2D space. <br>
//!  The following transformations are implemented : <br>
//!  . Translation, Rotation, Scale <br>
//!  . Symmetry with respect to a point and a line. <br>
//!  Complex transformations can be obtained by combining the <br>
//!  previous elementary transformations using the method Multiply. <br>
//!  The transformations can be represented as follow : <br>
//! <br>
//!       V1   V2   T       XY        XY <br>
//!    | a11  a12  a13 |   | x |     | x'| <br>
//!    | a21  a22  a23 |   | y |     | y'| <br>
//!    |  0    0    1  |   | 1 |     | 1 | <br>
class gp_Trsf2d  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 
//! Returns identity transformation. <br>
gp_Trsf2d();
//! Creates a 2d transformation in the XY plane from a <br>
//!          3d transformation . <br>
gp_Trsf2d(const gp_Trsf& T);

//!  Changes the transformation into a symmetrical transformation. <br>
//!  P is the center of the symmetry. <br>
  void SetMirror(const gp_Pnt2d& P) ;


//!  Changes the transformation into a symmetrical transformation. <br>
//!  A is the center of the axial symmetry. <br>
Standard_EXPORT   void SetMirror(const gp_Ax2d& A) ;

//!  Changes the transformation into a rotation. <br>
//!  P is the rotation's center and Ang is the angular value of the <br>
//!  rotation in radian. <br>
  void SetRotation(const gp_Pnt2d& P,const Standard_Real Ang) ;

//!  Changes the transformation into a scale. <br>
//!  P is the center of the scale and S is the scaling value. <br>
  void SetScale(const gp_Pnt2d& P,const Standard_Real S) ;


//!  Changes a transformation allowing passage from the coordinate <br>
//!  system "FromSystem1" to the coordinate system "ToSystem2". <br>
Standard_EXPORT   void SetTransformation(const gp_Ax2d& FromSystem1,const gp_Ax2d& ToSystem2) ;


//!  Changes the transformation allowing passage from the basic <br>
//!  coordinate system <br>
//!  {P(0.,0.,0.), VX (1.,0.,0.), VY (0.,1.,0.)} <br>
//!  to the local coordinate system defined with the Ax2d ToSystem. <br>
Standard_EXPORT   void SetTransformation(const gp_Ax2d& ToSystem) ;

//!  Changes the transformation into a translation. <br>
//!  V is the vector of the translation. <br>
  void SetTranslation(const gp_Vec2d& V) ;

//!  Makes the transformation into a translation from <br>
//!  the point P1 to the point P2. <br>
  void SetTranslation(const gp_Pnt2d& P1,const gp_Pnt2d& P2) ;

//!  Replaces the translation vector with V. <br>
Standard_EXPORT   void SetTranslationPart(const gp_Vec2d& V) ;

//!  Modifies the scale factor. <br>
Standard_EXPORT   void SetScaleFactor(const Standard_Real S) ;
//! Returns true if the determinant of the vectorial part of <br>
//! this transformation is negative.. <br>
  Standard_Boolean IsNegative() const;

//!  Returns the nature of the transformation. It can be  an <br>
//! identity transformation, a rotation, a translation, a mirror <br>
//! (relative to a point or an axis), a scaling transformation, <br>
//! or a compound transformation. <br>
  gp_TrsfForm Form() const;
//! Returns the scale factor. <br>
  Standard_Real ScaleFactor() const;

//!  Returns the translation part of the transformation's matrix <br>
 const gp_XY& TranslationPart() const;


//!  Returns the vectorial part of the transformation. It is a <br>
//!  2*2 matrix which includes the scale factor. <br>
Standard_EXPORT   gp_Mat2d VectorialPart() const;

//!  Returns the homogeneous vectorial part of the transformation. <br>
//!  It is a 2*2 matrix which doesn't include the scale factor. <br>
//!  The coefficients of this matrix must be multiplied by the <br>
//!  scale factor to obtain the coefficients of the transformation. <br>
 const gp_Mat2d& HVectorialPart() const;


//!  Returns the angle corresponding to the rotational component <br>
//!  of the transformation matrix (operation opposite to SetRotation()). <br>
Standard_EXPORT   Standard_Real RotationPart() const;

//!  Returns the coefficients of the transformation's matrix. <br>
//!  It is a 2 rows * 3 columns matrix. <br>
//! Raises OutOfRange if Row < 1 or Row > 2 or Col < 1 or Col > 3 <br>
  Standard_Real Value(const Standard_Integer Row,const Standard_Integer Col) const;


Standard_EXPORT   void Invert() ;

//!  Computes the reverse transformation. <br>
//!  Raises an exception if the matrix of the transformation <br>
//!  is not inversible, it means that the scale factor is lower <br>
//!  or equal to Resolution from package gp. <br>
  gp_Trsf2d Inverted() const;

  gp_Trsf2d Multiplied(const gp_Trsf2d& T) const;
  gp_Trsf2d operator *(const gp_Trsf2d& T) const
{
  return Multiplied(T);
}



//!  Computes the transformation composed from <T> and  <me>. <br>
//!  In a C++ implementation you can also write Tcomposed = <me> * T. <br>
//!  Example : <br>
//!      Trsf2d T1, T2, Tcomp; ............... <br>
//!      //composition : <br>
//!        Tcomp = T2.Multiplied(T1);         // or   (Tcomp = T2 * T1) <br>
//!      // transformation of a point <br>
//!        Pnt2d P1(10.,3.,4.); <br>
//!        Pnt2d P2 = P1.Transformed(Tcomp);  //using Tcomp <br>
//!        Pnt2d P3 = P1.Transformed(T1);     //using T1 then T2 <br>
//!        P3.Transform(T2);                  // P3 = P2 !!! <br>
Standard_EXPORT   void Multiply(const gp_Trsf2d& T) ;
  void operator *=(const gp_Trsf2d& T) 
{
  Multiply(T);
}



//!  Computes the transformation composed from <me> and T. <br>
//!  <me> = T * <me> <br>
Standard_EXPORT   void PreMultiply(const gp_Trsf2d& T) ;


Standard_EXPORT   void Power(const Standard_Integer N) ;

//!  Computes the following composition of transformations <br>
//!  <me> * <me> * .......* <me>,  N time. <br>
//!  if N = 0 <me> = Identity <br>
//!  if N < 0 <me> = <me>.Inverse() *...........* <me>.Inverse(). <br>
  gp_Trsf2d Powered(const Standard_Integer N) ;

  void Transforms(Standard_Real& X,Standard_Real& Y) const;
//! Transforms  a doublet XY with a Trsf2d <br>
  void Transforms(gp_XY& Coord) const;
    Standard_Real _CSFDB_Getgp_Trsf2dscale() const { return scale; }
    void _CSFDB_Setgp_Trsf2dscale(const Standard_Real p) { scale = p; }
    gp_TrsfForm _CSFDB_Getgp_Trsf2dshape() const { return shape; }
    void _CSFDB_Setgp_Trsf2dshape(const gp_TrsfForm p) { shape = p; }
    const gp_Mat2d& _CSFDB_Getgp_Trsf2dmatrix() const { return matrix; }
    const gp_XY& _CSFDB_Getgp_Trsf2dloc() const { return loc; }


friend class gp_GTrsf2d;


 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& gp_Trsf2d_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real scale;
gp_TrsfForm shape;
gp_Mat2d matrix;
gp_XY loc;


};


#include <gp_Trsf2d.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
