// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKUnix_RegExp_HeaderFile
#define _WOKUnix_RegExp_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WOKUnix_RegExp_HeaderFile
#include <Handle_WOKUnix_RegExp.hxx>
#endif

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _WOKUnix_RESyntax_HeaderFile
#include <WOKUnix_RESyntax.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_ProgramError;
class TCollection_HAsciiString;


//! provides regular expression matching and searching <br>
class WOKUnix_RegExp : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! creates a class instance <br>
Standard_EXPORT WOKUnix_RegExp();

//! creates a class instance with given pattern that denotes a set <br>
//!          of strings. Defines a translation table <aTransTbl> and <br>
//!          its length <aTblLen> to perform character translation. <br>
//!          Supply NULL for <aTransTbl> and zero value for <aTblLen> <br>
//!          if no translation necessary. It is possible to set <br>
//!          syntax of the regular expression by meaning <aSyntax> <br>
//!          parameter. <br>
//!  Warning: raises if syntax of the regular expression given is incorrect <br>
Standard_EXPORT WOKUnix_RegExp(const Handle(TCollection_HAsciiString)& aPattern,const WOKUnix_RESyntax aSyntax = WOKUnix_RESyntaxAWK,const Standard_Address aTransTbl = NULL,const Standard_Integer aTblLen = 0);

//! destroys all resources attached to the class instanse <br>
Standard_EXPORT   void Destroy() ;
~WOKUnix_RegExp()
{
  Destroy();
}


//! sets a new match pattern and possibly a new pattern syntax <br>
//!  Warning: raises if the syntax given is incorrect <br>
Standard_EXPORT   void SetPattern(const Handle(TCollection_HAsciiString)& aPattern,const WOKUnix_RESyntax aSyntax = WOKUnix_RESyntaxAWK,const Standard_Address aTransTbl = NULL,const Standard_Integer aTblLen = 0) ;

//! searches a sub-string in the <aString> which matches <br>
//!          the specified pattern starting at index <aStartPos>. <br>
//!          Returns an index of the match position on success. <br>
//!          Returns -1 if no match was found. <br>
//!          Returns -2 if error was occur. <br>
//!  Warning: raises if no search pattern was set <br>
Standard_EXPORT   Standard_Integer Search(const Handle(TCollection_HAsciiString)& aString,const Standard_Integer aStartPos = 1) const;

//! match the pattern given against the string <aString> <br>
//!          starting at index <aStartPos>. Do not consider matching <br>
//!          past the position <aStopPos>. <br>
//!          Returns the length of the string matched on success. <br>
//!          Returns -1 if no match was found. <br>
//!          Returns -2 if error was occur. <br>
//!  Warning: raises if no search pattern was set <br>
Standard_EXPORT   Standard_Integer Match(const Handle(TCollection_HAsciiString)& aString,const Standard_Integer aStartPos = 1,const Standard_Integer aStopPos = 1) const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Address myBuffer;
Standard_Boolean myAlloc;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
