// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKTools_BasicMapIterator_HeaderFile
#define _WOKTools_BasicMapIterator_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class WOKTools_BasicMap;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class  provides    basic   services  for the <br>
//! iterators  on Maps. The  iterators  are  inherited <br>
//! from this one. <br>
//! <br>
//! The  iterator   contains  an   array   of pointers <br>
//! (buckets). Each bucket is a  pointer  on a node. A <br>
//! node contains a pointer on the next node. <br>
//! <br>
//! This class  provides also basic  services for  the <br>
//! implementation of Maps. <br>
class WOKTools_BasicMapIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Resets the iterator to the first node. <br>
Standard_EXPORT   void Reset() ;
//! Returns True if there is a current  element in the <br>
//!          iterator. <br>
  Standard_Boolean More() const;

//! Sets the  iterator   to the  next   node.  If  the <br>
//! iterator is empty it will not change. <br>
Standard_EXPORT   void Next() ;





protected:

 // Methods PROTECTED
 // 

//! Creates an empty iterator. <br>
Standard_EXPORT WOKTools_BasicMapIterator();

//! Initialize on the first node in the buckets. <br>
Standard_EXPORT WOKTools_BasicMapIterator(const WOKTools_BasicMap& M);

//! Initialize on the first node in the buckets. <br>
Standard_EXPORT   void Initialize(const WOKTools_BasicMap& M) ;


 // Fields PROTECTED
 //
Standard_Address myNode;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myNbBuckets;
Standard_Address myBuckets;
Standard_Integer myBucket;


};


#include <WOKTools_BasicMapIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
