// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKNT_ShellOutput_HeaderFile
#define _WOKNT_ShellOutput_HeaderFile

#ifndef _OSD_File_HeaderFile
#include <OSD_File.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColStd_HSequenceOfHAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines root class to manage output of sub-process <br>
class WOKNT_ShellOutput  : public OSD_File {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! provides 'cleanup' functionality <br>
Standard_EXPORT virtual  void Cleanup() ;
~WOKNT_ShellOutput()
{
  Cleanup();
}


//! clears output buffer(s) of sub-process <br>
Standard_EXPORT virtual  void Clear()  = 0;

//! returns standard output of sub-process <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString Echo()  = 0;

//! returns standard error output of sub-process <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString Errors()  = 0;

//! creates an I/O object for reading a standard output of sub-process <br>
//!          and returns this object handle. <br>
//!  Warning: returns INVALID_HANDLE_VALUE in case of failure <br>
Standard_EXPORT virtual  Standard_Integer OpenStdOut()  = 0;

//! closes an I/O object's handle opened by 'OpenStdOut' method <br>
Standard_EXPORT virtual  void CloseStdOut()  = 0;

//! creates an I/O object for reading a standard error output of sub-process <br>
//!          and returns this object handle <br>
//!  Warning: returns INVALID_HANDLE_VALUE in case of failure <br>
Standard_EXPORT virtual  Standard_Integer OpenStdErr()  = 0;

//! closes an I/O object's handle opened by 'OpenStdErr' method <br>
Standard_EXPORT virtual  void CloseStdErr()  = 0;

//! waits for sub-process termination <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString SyncStdOut()  = 0;

//! same as 'SyncStdOut' method <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString SyncStdErr()  = 0;





protected:

 // Methods PROTECTED
 // 

//! protected constructor <br>
Standard_EXPORT WOKNT_ShellOutput();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
