// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_SpotLight_HeaderFile
#define _Vrml_SpotLight_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Quantity_Color;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! specifies a spot light node of VRML nodes specifying <br>
//!         properties of lights. <br>
//!  This  node  defines  a  spotlight  light  source. <br>
//!  A  spotlight  is  placed  at  a  fixed  location  in  3D-space <br>
//!  and  illuminates in  a  cone  along  a  particular  direction. <br>
//!  The  intensity  of  the  illumination  drops  off  exponentially <br>
//!  as  a  ray  of  light  diverges  from  this  direction  toward <br>
//!  the  edges  of  cone. <br>
//!  The  rate  of  drop-off  and  agle  of  the  cone  are  controlled <br>
//!  by  the  dropOfRate  and  cutOffAngle <br>
//!  Color is  written  as  an  RGB  triple. <br>
//!  Light intensity must be in the range 0.0 to 1.0, inclusive. <br>
class Vrml_SpotLight  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_SpotLight();


Standard_EXPORT Vrml_SpotLight(const Standard_Boolean aOnOff,const Standard_Real aIntensity,const Quantity_Color& aColor,const gp_Vec& aLocation,const gp_Vec& aDirection,const Standard_Real aDropOffRate,const Standard_Real aCutOffAngle);


Standard_EXPORT   void SetOnOff(const Standard_Boolean anOnOff) ;


Standard_EXPORT   Standard_Boolean OnOff() const;


Standard_EXPORT   void SetIntensity(const Standard_Real aIntensity) ;


Standard_EXPORT   Standard_Real Intensity() const;


Standard_EXPORT   void SetColor(const Quantity_Color& aColor) ;


Standard_EXPORT   Quantity_Color Color() const;


Standard_EXPORT   void SetLocation(const gp_Vec& aLocation) ;


Standard_EXPORT   gp_Vec Location() const;


Standard_EXPORT   void SetDirection(const gp_Vec& aDirection) ;


Standard_EXPORT   gp_Vec Direction() const;


Standard_EXPORT   void SetDropOffRate(const Standard_Real aDropOffRate) ;


Standard_EXPORT   Standard_Real DropOffRate() const;


Standard_EXPORT   void SetCutOffAngle(const Standard_Real aCutOffAngle) ;


Standard_EXPORT   Standard_Real CutOffAngle() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myOnOff;
Standard_Real myIntensity;
Quantity_Color myColor;
gp_Vec myLocation;
gp_Vec myDirection;
Standard_Real myDropOffRate;
Standard_Real myCutOffAngle;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
