// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_Separator_HeaderFile
#define _Vrml_Separator_HeaderFile

#ifndef _Vrml_SeparatorRenderCulling_HeaderFile
#include <Vrml_SeparatorRenderCulling.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  defines a Separator node of VRML specifying group properties. <br>
//!  This group node performs a push (save) of the traversal state before traversing its children <br>
//!  and a pop (restore) after traversing them. This isolates the separator's children from the <br>
//!  rest of the scene graph. A separator can include lights, cameras, coordinates, normals, <br>
//!  bindings, and all other properties. <br>
//!  Separators can also perform render culling. Render culling skips over traversal of the <br>
//!  separator's children if they are not going to be rendered, based on the comparison of the <br>
//!  separator's bounding box with the current view volume. Culling is controlled by the <br>
//!  renderCulling field. These are set to AUTO by default, allowing the implementation to <br>
//!  decide whether or not to cull. <br>
class Vrml_Separator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_Separator(const Vrml_SeparatorRenderCulling aRenderCulling);


Standard_EXPORT Vrml_Separator();


Standard_EXPORT   void SetRenderCulling(const Vrml_SeparatorRenderCulling aRenderCulling) ;


Standard_EXPORT   Vrml_SeparatorRenderCulling RenderCulling() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Vrml_SeparatorRenderCulling myRenderCulling;
Standard_Boolean myFlagPrint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
